package com.testor.module.safe.model.vo;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.testor.common.util.excel.LocalDateTimeConverter;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import java.net.URL;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * @author rsq
 * @program zlmy_boot
 * @return
 **/
@Data
@AllArgsConstructor
@NoArgsConstructor
public class TSafeHazardExportVO {

    @ExcelIgnore
    private String orgId;

    @ExcelProperty(value = "序号", index = 0)
    private Integer number;

    @ExcelProperty(value = "隐患编号", index = 1)
    private String numbering;

    @ExcelProperty(value = "大区单位", index = 2)
    private String regionalUnits;

    @ExcelProperty(value = "经营部", index = 3)
    private String businessDepartment;

    @ExcelProperty(value = "基层企业", index = 4)
    private String grassrootsUnits;

    @ExcelProperty(value = "隐患所属企业类型", index = 5)
    private String grassroots;

    @ExcelProperty(value = "隐患位置", index = 6)
    private String locationName;

    @ExcelProperty(value = "隐患描述", index = 7)
    private String remarks;

    @ExcelProperty(value = "隐患级别", index = 8)
    private String levelName;

    @ExcelProperty(value = "隐患分类", index = 9)
    private String classifyName;

    @ExcelProperty(value = "隐患类型", index = 10)
    private String typeName;

    @ExcelProperty(value = "隐患原因", index = 11)
    private String problemCauses;

    @ExcelProperty(value = "发现形式", index = 12)
    private String checkType;

    @ExcelProperty(value = "完成情况", index = 13)
    private String statusName;

    @ExcelProperty(value = "检查日期", index = 14, converter = LocalDateTimeConverter.class)
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createDate;

    @ExcelProperty(value = "整改措施", index = 15)
    private String rectificationReform;

    @ExcelProperty(value = "整改人", index = 16)
    private String rectifyPeopleName;

    @ExcelProperty(value = "整改验收人", index = 17)
    private String acceptanceName;

    @ExcelProperty(value = "是否重复", index = 18)
    private String isRepeat;

    @ExcelProperty(value = "计点分数", index = 19)
    private Long score;

}
