package com.testor.module.safeCheck.controller;

import com.testor.module.safeCheck.model.domain.TSafeHazardCheckPlan;
import com.testor.module.safeCheck.model.dto.TSafeHazardCheckPlanDTO;
import com.testor.module.safeCheck.model.dto.TSafeHazardCheckPlanParam;
import com.testor.module.safeCheck.model.vo.SafeHazardCheckPlanDetailVO;
import com.testor.module.safeCheck.model.vo.TSafeHazardCheckPlanVO;
import com.testor.module.safeCheck.service.TSafeHazardCheckPlanService;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 巡检计划Controller
 *
 * @author testor-framework
 * @date 2022-08-04 11:07:52
 */
@RestController
@RequestMapping("/safeCheck/checkPlan")
@Api(value = "TSafeHazardCheckPlan", tags = "巡检计划")
@Slf4j
public class TSafeHazardCheckPlanController extends SuperController
{
    @Autowired
    private TSafeHazardCheckPlanService tSafeHazardCheckPlanService;

    /* Generated Method*/
	@ApiOperation(value = "新增、修改 巡检计划", notes = "Add TSafeHazardCheckPlan")
	@PostMapping(value = "/edit")
	public BaseResponse<TSafeHazardCheckPlan>addEntity(@RequestBody TSafeHazardCheckPlanDTO addRequest) {
		return tSafeHazardCheckPlanService.editCheckPlan(addRequest);
	}

	@ApiOperation(value = "获取 巡检计划 ", notes = "Get TSafeHazardCheckPlan By Id")
	@GetMapping(value = "/get")
	public BaseResponse<SafeHazardCheckPlanDetailVO> getById(String id){
		BaseResponse<SafeHazardCheckPlanDetailVO> baseResponse=new BaseResponse<>();
		SafeHazardCheckPlanDetailVO detailVO = tSafeHazardCheckPlanService.findById(id);
		baseResponse.setData(detailVO);
		return baseResponse;
	}

	@ApiOperation(value = "删除 巡检计划 ", notes = "delete TSafeHazardCheckPlan By Id")
	@GetMapping(value = "/delete")
	public BaseResponse<BizGeneralResponse> deleteEntity(@RequestParam("planId") String planId){
		BaseResponse baseResponse= tSafeHazardCheckPlanService.deletePlan(planId);
		return baseResponse;
	}

	@ApiOperation(value = "获取 巡检计划 分页列表", notes = "List TSafeRiskPoint with page")
	@PostMapping(value = "/list")
	public  BaseResponse<BaseResponseList<TSafeHazardCheckPlanVO>>listEntity(@RequestBody TSafeHazardCheckPlanParam param){
		BaseResponse<BaseResponseList<TSafeHazardCheckPlanVO>>baseResponse=new BaseResponse<>();
		BaseResponseList<TSafeHazardCheckPlanVO> resultList= tSafeHazardCheckPlanService.listByPage(param);
		baseResponse.setData(resultList);
		return baseResponse;
	}

}
