package com.testor.module.safeCheck.dao;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.safeCheck.model.domain.TSafeHazardCheckObject;
import com.testor.module.safeCheck.model.domain.TSafeHazardCheckPlan;
import com.testor.module.safeCheck.model.dto.TSafeHazardCheckPlanParam;
import com.testor.module.safeCheck.model.vo.SafeHazardCheckPlanDetailVO;
import com.testor.module.safeCheck.model.vo.TSafeHazardCheckPlanVO;
import com.tongtech.tfw.backend.common.models.supers.SuperDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 巡检计划Mapper接口
 *
 * @author testor-framework
 * @date 2022-08-04 11:07:52
 */
public interface TSafeHazardCheckPlanDao extends SuperDao<TSafeHazardCheckPlan>
{
    /**
     * 分页查询
     * @param param
     * @return
     */
    IPage<TSafeHazardCheckPlanVO> listPage(Page<TSafeHazardCheckPlanVO> page, @Param("query") TSafeHazardCheckPlanParam param);

    /**
     * 根据id获取巡检计划
     * @return
     */
    SafeHazardCheckPlanDetailVO findById(@Param("planId") String planId);

    /**
     * @param param
     * @return
     */
    List<TSafeHazardCheckPlan> findByObjectInfo(@Param("query") TSafeHazardCheckObject param);
}
