package com.testor.module.safeCheck.model.vo;

import cn.hutool.core.date.DateUtil;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * 巡检计划对象 t_safe_hazard_check_plan
 * 
 * @author testor-framework
 * @date 2022-08-04 11:07:52
 */
@ApiModel(value = "TSafeHazardCheckPlanVO对象" , description = "")
@Data
public class TSafeHazardCheckPlanVO implements Serializable
{
    private static final long serialVersionUID = 1L;

  @ApiModelProperty(value = "id")
  private String id;

  @ApiModelProperty(value = "排查单位")
  private String orgId;

  @ApiModelProperty("业务单位")
  private String businessOrgName;

  @ApiModelProperty(value = "企业名称")
  private String orgName;

  @ApiModelProperty(value = "被排查单位")
  private String checkedOrgId;

  @ApiModelProperty(value = "被排查单位")
  private String checkedOrgName;

  @ApiModelProperty(value = "名称")
  private String name;

  @ApiModelProperty(value = "编码")
  private String code;

  @ApiModelProperty(value = "计划开始时间")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date startDate;

  public LocalDateTime getStartDate() {
    return DateUtil.toLocalDateTime(startDate);
  }

  @ApiModelProperty(value = "计划结束时间")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date endDate;
  public LocalDateTime getEndDate() {
    return DateUtil.toLocalDateTime(endDate);
  }



  @ApiModelProperty(value = "提前小时")
  private Long advanceHour;

  @ApiModelProperty(value = "0-未开始且未派发任务；1-未开始 已派发任务； 2-进行中； 3-已完成")
  private Integer planStatus;

  @ApiModelProperty(value = "排查对象")
  private String checkObjectNames;

//  @ApiModelProperty(value = "排查对象(编辑必填)")
//  private List<TSafeHazardCheckObject> checkObjectList;
//
//  @ApiModelProperty(value = "排查人员(编辑必填)")
//  private List<TSafeHazardCheckPeople> checkPeopleList;


}
