package com.testor.module.sys.controller;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.testor.biz.file.model.domain.SysFile;
import com.testor.biz.file.service.SysFileService;
import com.testor.common.core.utils.StringUtils;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Arrays;
import java.util.List;

@RestController
@Api(
        value = "文件管理",
        tags = {"新-文件管理"}
)
@RequestMapping({"/new/file"})
public class NewSysFileController {

    @Autowired
    private SysFileService sysFileService;


    @ApiOperation(
            value = "获取文件列表",
            notes = "获取文件列表"
    )
    @PostMapping({"/getFileInfoByIds"})
    public BaseResponse<List<SysFile>> addEntity(@RequestBody SysFile sysFile) {
        BaseResponse<List<SysFile>> baseResponse = new BaseResponse();
        String fileId = sysFile.getFileId();
        if (StringUtils.isNotBlank(fileId)){
            List<SysFile> sysFiles = sysFileService.list(new QueryWrapper<SysFile>().in("file_id", Arrays.asList(fileId.split(","))));
            baseResponse.setData(sysFiles);
        }
        return baseResponse;
    }


}
