package com.testor.module.sys.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.testor.biz.sys.org.model.domain.SysOrg;
import com.testor.module.sys.model.domian.NewSysOrg;
import com.tongtech.tfw.backend.common.models.supers.SuperDao;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

@Mapper
public interface NewSysOrgDao extends SuperDao<NewSysOrg> {
    @Select({"select org.* from t_sys_org org where (find_in_set(org.org_id,#{parentIds})  or org.parent_ids like '%,${orgId}%' or org.org_id = #{orgId}) and org.is_dept = '0'"})
    List<SysOrg> getOrgAllByLoginUser(@Param("parentIds") String parentIds, @Param("orgId") String orgId);



    @Select({"WITH RECURSIVE ParentChain AS (\n" +
            "\tSELECT\n" +
            "\t\torg_id,\n" +
            "\t\tparent_id,\n" +
            "\t\torg_name \n" +
            "\tFROM\n" +
            "\t\tt_sys_org \n" +
            "\tWHERE\n" +
            "\t\torg_id = '${orgId}' UNION ALL\n" +
            "\tSELECT\n" +
            "\t\to.org_id,\n" +
            "\t\to.parent_id,\n" +
            "\t\to.org_name \n" +
            "\tFROM\n" +
            "\t\tt_sys_org o\n" +
            "\t\tINNER JOIN ParentChain pc ON o.org_id = pc.parent_id \n" +
            "\t) SELECT\n" +
            "\torg_id,\n" +
            "\tparent_id,\n" +
            "\torg_name org_name \n" +
            "FROM\n" +
            "\tParentChain \n" +
            "WHERE\n" +
            "\tparent_id IS NOT NULL \n" +
            "\tAND parent_id != '0';"})
    List<NewSysOrg> findSubSectorPath(@Param("orgId") String orgId);


}
