package com.testor.module.sys.model.domian;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * <p>
 * 用户表
 * </p>
 *
 * @author caoqiang
 * @since 2024-09-03
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("t_sys_user_extend")
public class SysUserExtend implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 用户表主键
     */
    @TableId(value = "user_id")
    private String userId;

    /**
     * 人员类型code
     */
    @TableField("user_type_code")
    private String userTypeCode;

    /**
     * 人员类型名称
     */
    @TableField("user_type_name")
    private String userTypeName;

    /**
     * 状态：0正常 1删除 2停用
     */
    @TableField("status")
    private String status;

    /**
     * 创建者
     */
    @TableField("create_by")
    private String createBy;

    /**
     * 创建时间
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @TableField("create_date")
    private Date createDate;

    /**
     * 最后一次更新者
     */
    @TableField("update_by")
    private String updateBy;

    /**
     * 最后一次更新时间
     */
    @TableField("update_date")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateDate;

    /**
     * 备注
     */
    @TableField("remarks")
    private String remarks;


    public static final String USER_ID = "user_id";

    public static final String USER_TYPE_CODE = "user_type_code";

    public static final String USER_TYPE_NAME = "user_type_name";

    public static final String STATUS = "status";

    public static final String CREATE_BY = "create_by";

    public static final String CREATE_DATE = "create_date";

    public static final String UPDATE_BY = "update_by";

    public static final String UPDATE_DATE = "update_date";

    public static final String REMARKS = "remarks";

    @JsonIgnore
    public String getId(){
        return this.userId;
    }
    @JsonIgnore
    public void setId(String userId){
        this.userId = userId;
    }


}
