package com.testor.module.sys.model.dto;

import com.testor.biz.sys.user.model.dto.SysUserRequest;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.util.List;

/**
 * @ClassName: SysUserParam
 * @Description: TODO
 * @Author: lm
 * @CreateTime: 2024/1/3 14:11
 * @Version: 1.0
 */
@Data
public class SysUserParam extends SysUserRequest {
    @Pattern(
            regexp = "^[1-9]+[0-9]*$"
    )
    @NotNull
    @ApiModelProperty("每页数量")
    private Long limit;
    @Pattern(
            regexp = "^[1-9]+[0-9]*$"
    )
    @NotNull
    @ApiModelProperty("当前页数")
    private Long page;
    @ApiModelProperty("排序字段")
    private String orderBy;
    @ApiModelProperty("排序方式")
    private String orderType;

    @ApiModelProperty("IAM用户id")
    private String iamUserId;
    private Long offset;
    // 机构id列表
    private List<String> orgIdList;
    // 用户状态列表
    private List<String> statusList;


    @ApiModelProperty("是否只查询当前层级机构 0 否，1是")
    private String onlyCurrentOrgState;

}
