package com.testor.module.sys.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.testor.biz.sys.org.model.domain.SysOrg;
import com.testor.module.sys.model.domian.NewSysOrg;
import com.testor.module.sys.model.vo.SysOrgVo;

import java.util.List;

public interface NewSysOrgService extends IService<NewSysOrg> {

    /**
     * 获取下级单位 (含当前机构)
     * @param orgId
     * @return
     */
    List<NewSysOrg> getChildrenById(String orgId);

    /**
     * 获取下级单位id(包含当前机构)
     * @param orgId
     * @return
     */
    List<String> getIdsChildrenById(String orgId);


    /**
     * 获取下级单位 (不含当前机构)
     * @param orgId
     * @return
     */
    List<NewSysOrg> getSubInstitutions(String orgId);

    /**
     * 获取下级单位id(不含当前机构)
     * @param orgId
     * @return
     */
    List<String> getSubInstitutionIds(String orgId);


    String getOrgFullPathName(String orgId);

    /**
     * 获取下级单位
     * @param parentId
     * @return
     */
    List<NewSysOrg> getOrgListByParentId(String parentId);

    /**
     * 获取下级单位id
     * @param parentId
     * @return
     */
    List<String> getOrgIdListByParentId(String parentId);

    List<SysOrg> getOrgAllByLoginUser();

    List<NewSysOrg> getChildrenDept(String orgId);

    NewSysOrg getSysOrgByCode(String code);

    List<NewSysOrg> getOrgByIds(List<String> orgIds);

    /**
     * 根据机构id查询子级级本部机构id
     * @param orgId
     * @return
     */
    List<String> getChildDeptIdByParentId(String orgId);

    /**
     * 根据当前部门名称获取部门id(登录用户机构id)
     * @param name 部门名称
     * @return
     */
    String getDeptIdByName(String name);

    /**
     * 根据机构id查询 企业性质
     * @param orgId
     * @return
     */
    String getOrgNatureById(String orgId);

    /**
     * 根据机构id查询父级机构名称 例如 大区/经营部/xxxx粮库
     * @param orgId
     * @return
     */
    String findOrgPathNameByOrgId(String orgId);

    SysOrgVo lookOrg(String orgId);

    /**
     * 根据机构id获取机构类型
     * @param orgId
     * @return 0、不是北良公司 1、部 2、公司
     */
    Integer getOrgTypeByOrgId(String orgId);
}
