package com.testor.module.train.project.model.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecgframework.poi.excel.annotation.ExcelTarget;

/**
 * @title MyManagementExport
 * @description <TODO description class purpose>
 * @Author: qiao
 * @version:1.0.0
 * @create：5/23/23 4:05 PM
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
@ExcelTarget("TTrainProjectParamImport")
public class MyManagementExport {
    /**
     * 人员归属 本单位/相关方
     */
    @ApiModelProperty(value = "人员归属 本单位/相关方")
    @Excel(name = "人员归属", width = 20)
    private String personAffiliation;

    /**
     * 所属企业
     */
    @ApiModelProperty(value = "所属企业")
    @Excel(name = "所属企业", width = 20)
    private String company;

    /**
     * 所属部门
     */
    @ApiModelProperty(value = "所属部门")
    @Excel(name = "所属部门", width = 20)
    private String deptName;

    /**
     * 人员姓名id
     */
    @ApiModelProperty(value = "人员姓名id")
    @Excel(name = "人员姓名ID", width = 20)
    private String personNameId;

    /**
     * 人员姓名
     */
    @ApiModelProperty(value = "人员姓名")
    @Excel(name = "人员姓名", width = 20)
    private String personName;

    /**
     * 性别
     */
    @ApiModelProperty(value = "性别")
    @Excel(name = "性别", width = 20)
    private String sex;


    @ApiModelProperty(value = "当前状态 0 未开始 1 进行中 3 已完成 5 逾期未完成")
    @Excel(name = "完成情况", width = 20)
    private String currentStatus;
}
