package com.testor.module.train.project.model.enums;

import com.testor.common.core.utils.StringUtils;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author caq
 * @date 2024/9/6
 * @description  专业指标评分枚举
 */
@Getter
@AllArgsConstructor
public enum ProfessionalIndicatorScoreEnum {
    A_1("A_1","研究生及以上","1","A","学历"),
    A_2("A_2","本科","0.8","A","学历"),
    A_3("A_3","大专","0.6","A","学历"),
    A_4("A_4","中专","0.4","A","学历"),
    A_5("A_5","中专以下","0.2","A","学历"),
    B_1("B_1","安全科学与工程","2","B","专业"),
    B_2("B_2","机械工程","2","B","专业"),
    B_3("B_3","电气工程","2","B","专业"),
    B_4("B_4","土木工程","2","B","专业"),
    B_5("B_5","消防安全","2","B","专业"),
    B_6("B_6","农产品加工及贮藏工程","2","B","专业"),
    B_7("B_7","粮食工程","2","B","专业"),
    B_8("B_8","其他工程类专业","1.5","B","专业"),
    B_9("B_9","其他管理类专业","1.5","B","专业"),
    B_10("B_10","其他非理工科类专业","1","B","专业"),
    C_1("C_1","5年以上：安全生产管理岗位","3","C","安全生产相关管理工作经验"),
    C_2("C_2","5年以上：仓储、设备、工程、生产管理岗位","2","C","安全生产相关管理工作经验"),
    C_3("C_3","5年以上：其他管理岗位","1.5","C","安全生产相关管理工作经验"),
    C_4("C_4","3-5年：安全生产管理岗位","2","C","安全生产相关管理工作经验"),
    C_5("C_5","3-5年：仓储、设备、工程、生产管理岗位","1","C","安全生产相关管理工作经验"),
    C_6("C_6","3-5年：其他管理岗位","1","C","安全生产相关管理工作经验"),
    C_7("C_7","1-3年：安全生产管理岗位","1","C","安全生产相关管理工作经验"),
    C_8("C_8","1-3年：仓储、设备、工程、生产管理岗位","0.5","C","安全生产相关管理工作经验"),
    C_9("C_9","1-3年：其他管理岗位","0.4","C","安全生产相关管理工作经验"),
    C_10("C_10","1年以下","0","C","安全生产相关管理工作经验"),


    D_1("高级工程师职称(等同于)","高级工程师职称(等同于)","1.5","D","安全相关资格"),
    D_2("注册安全工程师","注册安全工程师","1.5","D","安全相关资格"),
    D_3("注册消防工程师","注册消防工程师","1.5","D","安全相关资格"),
    D_4("注册环保工程师","注册环保工程师","1.5","D","安全相关资格"),
    D_5("安全评价师","安全评价师","1.5","D","安全相关资格"),
    D_6("电气工程师","电气工程师","1.5","D","安全相关资格"),
    D_7("安全生产标准化评审专家","安全生产标准化评审专家","1.5","D","安全相关资格"),
    D_8("工程师职称(等同于)","工程师职称(等同于)","1","D","安全相关资格"),
    D_9("ISO45001职业健康安全管理体系审核员","ISO45001职业健康安全管理体系审核员","1","D","安全相关资格"),
    D_10("安全生产标准化评审员","安全生产标准化评审员","1","D","安全相关资格"),
    D_11("政府应急部门颁发的安全管理资格/培训证书","政府应急部门颁发的安全管理资格/培训证书","1","D","安全相关资格"),
    D_12("消防安全部门颁发的安全管理资格/培训证书","消防安全部门颁发的安全管理资格/培训证书","1","D","安全相关资格"),
    D_13("中粮集团或中粮贸易的安全管理培训合格证书","中粮集团或中粮贸易的安全管理培训合格证书","1","D","安全相关资格"),
    D_14("助理工程师职称(等同于)","助理工程师职称(等同于)","0.5","D","安全相关资格"),
    D_15("ISO45001职业健康安全管理体系内审员","ISO45001职业健康安全管理体系内审员","0.5","D","安全相关资格"),
    D_16("无任何职称或专业资格","无任何职称或专业资格","0","D","安全相关资格"),

    E_1("E_1","获得安全生产相关国家专利","1.5","E","安全生产管理成效"),
    E_2("E_2","主笔或参与完成中粮集团级别的安全生产调查研究报告","1.5","E","安全生产管理成效"),
    E_3("E_3","主笔或参与完成国家或行业安全生产标准的编写","1.5","E","安全生产管理成效"),
    E_4("E_4","以第一作者在中文核心期刊上发表安全管理专业论文","1.5","E","安全生产管理成效"),
    E_5("E_5","主导完成所在单位的安全生产标准化一级企业创建","1.5","E","安全生产管理成效"),
    E_6("E_6","主笔中粮集团安全生产管理制度或标准编写","1","E","安全生产管理成效"),
    E_7("E_7","组织完成中粮集团安全生产试点项目并通过验收","1","E","安全生产管理成效"),
    E_8("E_8","以第一作者在非核心专业报刊或《企业忠良》发表安全生产专业文章","1","E","安全生产管理成效"),
    E_9("E_9","主导完成所在单位的安全生产标准化二级企业创建","1","E","安全生产管理成效"),
    E_10("E_10","主笔或组织完成企业安全生产制度标准编写","0.5","E","安全生产管理成效"),
    E_11("E_11","组织完成中粮贸易安全生产试点项目并通过验收","0.5","E","安全生产管理成效"),
    E_12("E_12","主导完成所在单位的安全生产标准化三级企业创建","0.5","E","安全生产管理成效"),
    E_13("E_13","未取得以上安全生产相关管理成效","0","E","安全生产管理成效"),
    F_1("F_1","个人获得省部级或中粮集团安全生产荣誉称号","1","F","个人或所负责项目获奖情况"),
    F_2("F_2","所负责的安全生产相关项目、专项活动获得省部级或中粮集团的奖励","1","F","个人或所负责项目获奖情况"),
    F_3("F_3","个人获得地市级或中粮贸易安全生产荣誉称号","0.5","F","个人或所负责项目获奖情况"),
    F_4("F_4","所负责的安全生产相关项目、专项活动获得地市级或中粮贸易奖励","0.5","F","个人或所负责项目获奖情况"),
    F_5("F_5","个人获得县级或所在大区、东北港口平台安全生产荣誉称号","0.2","F","个人或所负责项目获奖情况"),
    F_6("F_6","所负责的安全生产相关项目、专项活动获得地市级或中粮贸易奖励","0.2","F","个人或所负责项目获奖情况"),
    F_7("F_7","未获得以上安全生产相关奖项","0","F","个人或所负责项目获奖情况"),

    ;
    /**
     * 指标代码
     */
    private String code;
    /**
     * 指标名称
     */
    private String name;
    /**
     * 指标值
     */
    private String score;
    /**
     * 指标类型
     */
    private String type;
    /**
     * 指标类型名称
     */
    private String typeName;


    public static String getScoreByCode(String code) {
        if(StringUtils.isBlank(code)) {
            return "0";
        }
        for (ProfessionalIndicatorScoreEnum value : ProfessionalIndicatorScoreEnum.values()) {
            if (value.getCode().equals(code)) {
                return value.getScore();
            }
        }
        return "0";
    }
}


