package com.testor.module.video.util;

import com.alibaba.fastjson.JSON;

import java.util.List;

/**
 * @Author:qiao
 * @Date：4/11/22 2:33 PM
 */
public class Beans {

    private Beans(){

    }

    /**
     * 对象转换
     * @param o
     * @param clazz 目标转换类
     * @param <T>  目标对象类
     * @return 目标对象
     */
    public static <T> T objectToBean(Object o,Class<T> clazz){
        String json = JSON.toJSONString(o);
        return JSON.parseObject(json,clazz);
    }

    /**
     * list<map> 转list<bean>
     * @param o  list<map>
     * @param clazz 目标转换类
     * @param <T> 目标对象类
     * @return 目标对象
     */
    public static <T> List<T> listToBean(Object o, Class<T> clazz){
        String json = JSON.toJSONString(o);
        return JSON.parseArray(json,clazz);
    }
}
