package com.testor.workflow.config;

import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.engine.RuntimeService;
import org.flowable.spring.SpringProcessEngineConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;

/**
 * 全局监听配置 ContextRefreshedEvent在类被初始化之后触发
 */
@Configuration
public class FlowableGlobListenerConfig implements ApplicationListener<ContextRefreshedEvent> {
    @Autowired
    private SpringProcessEngineConfiguration configuration;

    @Autowired
    private GlobalCompleteListener globalCompleteListener;

    @Autowired
    private RuntimeService runtimeService;

    @Override
    public void onApplicationEvent(ContextRefreshedEvent event) {
        FlowableEventDispatcher dispatcher = configuration.getEventDispatcher();
        //任务完成全局监听
        //dispatcher.addEventListener(globalCompleteListener, FlowableEngineEventType.TASK_COMPLETED);
        dispatcher.addEventListener(globalCompleteListener, FlowableEngineEventType.PROCESS_COMPLETED);
    }
}
