package com.testor.workflow.config;

import com.testor.biz.sys.org.model.domain.SysOrg;
import com.testor.biz.sys.org.service.SysOrgService;
import com.tongtech.tfw.backend.common.context.ContextUtils;
import com.tongtech.tfw.backend.common.models.sys.UserInfo;
import com.tongtech.tfw.workflow.apis.task.model.dto.CompleteTask;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Map;

/**
 *
 */
@Aspect  // 使用@Aspect注解声明一个切面
@Component
public class TaskCompleteAspect {

    @Resource
    private SysOrgService orgService;

    @Pointcut("execution(* com.tongtech.tfw.workflow.apis.task.controller.WfTaskController.completeTask(..))")
    public void addTreeLevelPointCut() {
    }

    // 用户所属层级 '3' 粮库 ； '2' 区域公司 ； '1' 总部，默认路径；
    // private String treeLevel;

    /**
     * 启动流程后 创建任务 后 修改 任务执行人
     * @param joinPoint
     */
    @Before("addTreeLevelPointCut()")
    public void runBefore(JoinPoint joinPoint) {

        System.out.println("TaskCompleteAspect runBefore()任务完成前执行执行！！！！！");

        try {
            UserInfo curUser = ContextUtils.getLoginUser();
            SysOrg sysOrg = orgService.getById(curUser.getOrgId());
            Object[] args = joinPoint.getArgs();
            for (Object arg : args) {
                if (arg instanceof CompleteTask){
                    CompleteTask completeTask = (CompleteTask) arg;
                    Map variables = completeTask.getVars();
                    variables.put("treeLevel", sysOrg.getTreeLevel().toString());
                    variables.put("submitter", curUser.getUserId());
                    completeTask.setVars(variables);
                }
            }

        }catch (Throwable e) {
            e.printStackTrace();
        }

    }
}


