package org.flowable.ui.common.security;

import com.alibaba.fastjson.JSON;
import org.flowable.idm.api.User;
import org.flowable.ui.common.model.RemoteUser;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

import java.util.ArrayList;
import java.util.List;

/**
 * SecurityUtils
 *
 * @author Created by ivan on 2020/8/4 .
 * @version 1.0
 */
public class SecurityUtils{

  private static User assumeUser;

  private SecurityUtils() {}

  /** Get the login of the current user. */
  public static String getCurrentUserId() {
    User user = getCurrentUserObject();
    if (user != null) {
      return user.getId();
    }
    return null;
  }

  /** @return the {@link User} object associated with the current logged in user. */
  public static User getCurrentUserObject() {
    if (assumeUser != null) {
      return assumeUser;
    }

    System.out.println("******zlmy boot tfw-workflow getCurrentUserObject************");
    /*User user = null;
    FlowableAppUser appUser = getCurrentFlowableAppUser();
    if (appUser != null) {
      user = appUser.getUserObject();
    }
    return user;*/
    RemoteUser user = new RemoteUser();
    user.setId("admin");
    user.setDisplayName("Administrator");
    user.setFirstName("Administrator");
    user.setLastName("Administrator");
    user.setEmail("admin@flowable.com");
    user.setPassword("123456");
    List<String> pris = new ArrayList<>();
    pris.add(DefaultPrivileges.ACCESS_MODELER);
    pris.add(DefaultPrivileges.ACCESS_IDM);
    pris.add(DefaultPrivileges.ACCESS_ADMIN);
    pris.add(DefaultPrivileges.ACCESS_TASK);
    pris.add(DefaultPrivileges.ACCESS_REST_API);
    user.setPrivileges(pris);
    System.out.println("******zlmy boot tfw-workflow getCurrentUserObject user************"+ JSON.toJSONString(user));
    return user;
  }

  public static FlowableAppUser getCurrentFlowableAppUser() {
    FlowableAppUser user = null;
    SecurityContext securityContext = SecurityContextHolder.getContext();
    if (securityContext != null && securityContext.getAuthentication() != null) {
      Object principal = securityContext.getAuthentication().getPrincipal();
      if (principal instanceof FlowableAppUser) {
        user = (FlowableAppUser) principal;
      }
    }
    return user;
  }

  public static boolean currentUserHasCapability(String capability) {
    FlowableAppUser user = getCurrentFlowableAppUser();
    for (GrantedAuthority grantedAuthority : user.getAuthorities()) {
      if (capability.equals(grantedAuthority.getAuthority())) {
        return true;
      }
    }
    return false;
  }

  public static void assumeUser(User user) {
    assumeUser = user;
  }

  public static void clearAssumeUser() {
    assumeUser = null;
  }
}
