/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.springboot.autoconfigure;

import com.tongweb.juli.logging.Log;
import com.tongweb.juli.logging.LogFactory;
import java.time.Duration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.ResourceProperties;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcProperties;
import org.springframework.http.CacheControl;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(name={"org.springframework.boot.autoconfigure.web.ResourceProperties"})
@ConditionalOnProperty(name={"server.tongweb.staticresources.repair.routes.conflicting"}, havingValue="false", matchIfMissing=true)
public class StaticResourcesAutoConfigure
implements WebMvcConfigurer {
    private static final Log logger = LogFactory.getLog(StaticResourcesAutoConfigure.class);
    @Autowired
    private ResourceProperties resourceProperties;
    @Autowired
    private WebMvcProperties mvcProperties;
    private static final String[] SERVLET_RESOURCE_LOCATIONS = new String[]{"/"};

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        if (!this.resourceProperties.isAddMappings()) {
            logger.debug((Object)"Default resource handling disabled");
            return;
        }
        Duration cachePeriod = this.resourceProperties.getCache().getPeriod();
        CacheControl cacheControl = this.resourceProperties.getCache().getCachecontrol().toHttpCacheControl();
        if (!registry.hasMappingForPattern("/webjars/**")) {
            registry.addResourceHandler(new String[]{"/webjars/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/"}).setCachePeriod(this.getSeconds(cachePeriod)).setCacheControl(cacheControl);
        }
        String staticPathPattern = this.mvcProperties.getStaticPathPattern();
        registry.addResourceHandler(new String[]{staticPathPattern}).addResourceLocations(this.optimizeResourceLocations(this.resourceProperties.getStaticLocations())).setCachePeriod(this.getSeconds(cachePeriod)).setCacheControl(cacheControl);
    }

    private String[] optimizeResourceLocations(String[] originStaticLocations) {
        String[] optimizationStaticLocations;
        if (originStaticLocations == null || originStaticLocations.length < 1) {
            return SERVLET_RESOURCE_LOCATIONS;
        }
        String firstLocation = originStaticLocations[0];
        if (!firstLocation.equals("/")) {
            optimizationStaticLocations = new String[originStaticLocations.length + SERVLET_RESOURCE_LOCATIONS.length];
            System.arraycopy(SERVLET_RESOURCE_LOCATIONS, 0, optimizationStaticLocations, 0, SERVLET_RESOURCE_LOCATIONS.length);
            System.arraycopy(originStaticLocations, 0, optimizationStaticLocations, SERVLET_RESOURCE_LOCATIONS.length, originStaticLocations.length);
        } else {
            optimizationStaticLocations = originStaticLocations;
        }
        return optimizationStaticLocations;
    }

    private Integer getSeconds(Duration cachePeriod) {
        return cachePeriod != null ? Integer.valueOf((int)cachePeriod.getSeconds()) : null;
    }
}

