/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.dataview.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import com.tongtech.tfw.dataview.model.domain.TDataviewConfig;
import com.tongtech.tfw.dataview.model.dto.TDataviewConfigDelParam;
import com.tongtech.tfw.dataview.model.dto.TDataviewConfigParam;
import com.tongtech.tfw.dataview.service.TDataviewConfigService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dataview/config"})
@Api(value="TDataviewConfig", tags={"DataView \u53ef\u89c6\u5316\u914d\u7f6e"})
public class TDataviewConfigController
extends SuperController {
    private static final Logger log = LoggerFactory.getLogger(TDataviewConfigController.class);
    @Autowired
    private TDataviewConfigService tDataviewConfigService;

    @ApiOperation(value="\u65b0\u589e \u53ef\u89c6\u5316\u914d\u7f6e", notes="\u65b0\u589e \u53ef\u89c6\u5316\u914d\u7f6e Add TDataviewConfig")
    @PostMapping(value={"/add"})
    public BaseResponse<TDataviewConfig> addEntity(@RequestBody TDataviewConfig addRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)((Object)addRequest))) {
            String id = IdHelper.getId32bit();
            TDataviewConfig data = (TDataviewConfig)((Object)BeanHelper.beanToBean((Object)((Object)addRequest), TDataviewConfig.class));
            data.setId(id);
            boolean result = this.tDataviewConfigService.save((Object)data);
            if (result) {
                TDataviewConfig newEntity = new TDataviewConfig();
                newEntity.setId(id);
                baseResponse.setData((Object)newEntity);
            }
        }
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6 \u53ef\u89c6\u5316\u914d\u7f6e ", notes="\u83b7\u53d6 \u53ef\u89c6\u5316\u914d\u7f6e Get TDataviewConfig By Id")
    @GetMapping(value={"/get"})
    public BaseResponse<TDataviewConfig> getById(String id) {
        BaseResponse baseResponse = new BaseResponse();
        if (StringHelper.isNotEmpty((CharSequence)id)) {
            TDataviewConfig data = (TDataviewConfig)((Object)this.tDataviewConfigService.getById((Serializable)((Object)id)));
            baseResponse.setData((Object)data);
        }
        return baseResponse;
    }

    @ApiOperation(value="\u4fee\u6539 \u53ef\u89c6\u5316\u914d\u7f6e ", notes="\u4fee\u6539 \u53ef\u89c6\u5316\u914d\u7f6e Update TDataviewConfig By Id")
    @PutMapping(value={"/update"})
    public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody TDataviewConfig updateRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)((Object)updateRequest)) && StringHelper.isNotEmpty((CharSequence)updateRequest.getId())) {
            TDataviewConfig data = (TDataviewConfig)((Object)BeanHelper.beanToBean((Object)((Object)updateRequest), TDataviewConfig.class));
            boolean result = this.tDataviewConfigService.updateById((Object)data);
            baseResponse.setData((Object)BizGeneralResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u5220\u9664 \u53ef\u89c6\u5316\u914d\u7f6e ", notes="\u5220\u9664 \u53ef\u89c6\u5316\u914d\u7f6e delete TDataviewConfig By Id")
    @PutMapping(value={"/delete"})
    public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TDataviewConfigDelParam deleteRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)deleteRequest) && StringHelper.isNotEmpty((CharSequence)deleteRequest.getId())) {
            TDataviewConfig data = new TDataviewConfig();
            data.setId(deleteRequest.getId());
            data.setStatus("1");
            boolean result = this.tDataviewConfigService.updateById((Object)data);
            baseResponse.setData((Object)BizGeneralResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u53ef\u89c6\u5316\u914d\u7f6e", notes="\u6279\u91cf\u5220\u9664\u53ef\u89c6\u5316\u914d\u7f6e delete TDataviewConfig by batch Id")
    @PutMapping(value={"/batch_delete"})
    public BaseResponse<BizGeneralResponse> deleteEntityBatch(@RequestBody TDataviewConfigDelParam deleteRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)deleteRequest) && !deleteRequest.getIds().isEmpty()) {
            ArrayList<TDataviewConfig> tDataviewConfigList = new ArrayList<TDataviewConfig>();
            for (String id : deleteRequest.getIds()) {
                TDataviewConfig data = new TDataviewConfig();
                data.setId(id);
                data.setStatus("1");
                tDataviewConfigList.add(data);
            }
            boolean result = this.tDataviewConfigService.updateBatchById(tDataviewConfigList);
            baseResponse.setData((Object)BizGeneralResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6 \u53ef\u89c6\u5316\u914d\u7f6e \u5206\u9875\u5217\u8868", notes="\u83b7\u53d6 \u53ef\u89c6\u5316\u914d\u7f6e \u5206\u9875\u5217\u8868 List TDataviewConfig with page")
    @GetMapping(value={"/list"})
    public BaseResponse<BaseResponseList<TDataviewConfig>> listEntity(TDataviewConfigParam param) {
        BaseResponse baseResponse = new BaseResponse();
        Long page = StringHelper.isEmpty((CharSequence)param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit = StringHelper.isEmpty((CharSequence)param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
        Page resultPage = new Page(page.longValue(), limit.longValue());
        QueryWrapper<TDataviewConfig> queryWrapper = this.createQuery(param);
        Page resultList = (Page)this.tDataviewConfigService.page((IPage)resultPage, (Wrapper)queryWrapper);
        BaseResponseList baseResponseList = new BaseResponseList();
        baseResponseList.setData(resultList.getRecords());
        baseResponseList.setTotal(resultList.getTotal());
        baseResponse.setData((Object)baseResponseList);
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6 \u53ef\u89c6\u5316\u914d\u7f6e \u5217\u8868", notes="\u83b7\u53d6 \u53ef\u89c6\u5316\u914d\u7f6e \u5217\u8868 List TDataviewConfig all")
    @GetMapping(value={"/datas"})
    public BaseResponse<BaseResponseList<TDataviewConfig>> listAllEntity(TDataviewConfigParam param) {
        BaseResponse baseResponse = new BaseResponse();
        QueryWrapper<TDataviewConfig> queryWrapper = this.createQuery(param);
        List resultList = this.tDataviewConfigService.list((Wrapper)queryWrapper);
        BaseResponseList baseResponseList = new BaseResponseList();
        baseResponseList.setData(resultList);
        baseResponseList.setTotal((long)resultList.size());
        baseResponse.setData((Object)baseResponseList);
        return baseResponse;
    }

    private QueryWrapper<TDataviewConfig> createQuery(TDataviewConfigParam queryParam) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getStatus())) {
            queryWrapper.eq((Object)"status", (Object)queryParam.getStatus());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getDataViewId())) {
            queryWrapper.eq((Object)"data_view_id", (Object)queryParam.getDataViewId());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getDetail())) {
            queryWrapper.eq((Object)"detail", (Object)queryParam.getDetail());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getComponent())) {
            queryWrapper.eq((Object)"component", (Object)queryParam.getComponent());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getStatus())) {
            queryWrapper.eq((Object)"status", (Object)queryParam.getStatus());
        } else {
            queryWrapper.ne((Object)"status", (Object)"1");
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getOrderBy())) {
            if (StringHelper.isNotEmpty((CharSequence)queryParam.getOrderType()) && "asc".equals(queryParam.getOrderType())) {
                queryWrapper.orderByAsc((Object)queryParam.getOrderBy());
            } else {
                queryWrapper.orderByDesc((Object)queryParam.getOrderBy());
            }
        } else {
            queryWrapper.orderByDesc((Object)"update_date");
        }
        return queryWrapper;
    }
}

