package com.testor.common.translation.impl;


import com.testor.common.annotation.TranslationType;
import com.testor.common.constant.TransConstant;
import com.testor.common.translation.TranslationInterface;
import com.testor.module.sys.service.NewSysFileService;
import lombok.AllArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * OSS翻译实现
 *
 * @author Lion Li
 */
@Component
@AllArgsConstructor
@TranslationType(type = TransConstant.FILE_ID_TO_URL)
public class FileUrlTranslationImpl implements TranslationInterface<String> {

    @Autowired
    private NewSysFileService newSysFileService;

    @Override
    public String translation(Object key, String other) {
        return newSysFileService.getFileUrlByIds(String.valueOf(key));
    }
}
