package com.testor.ddd.safetyControl.domain.space.service;

import com.testor.ddd.safetyControl.interfaces.model.dto.space.TSafeSpaceTypeDTO;
import com.testor.ddd.safetyControl.interfaces.model.dto.space.TSafeSpaceTypeDTOParam;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;

import java.util.List;

public interface SpaceTypeService {

    /**
     * 检测 名称、编码 是否都唯一
     * @param orgId
     * @param name
     * @param code
     * @return true - 唯一； false - 不唯一
     */
    boolean checkUniqueness(String id, String orgId, String name, String code);

    /**
     * 编辑空间
     * @param spaceTypeOrgDto
     * @return
     */
    BaseResponse editSpaceType(String userId, String orgId, TSafeSpaceTypeDTO spaceTypeOrgDto);

    BaseResponseList<TSafeSpaceTypeDTO> listByPage(TSafeSpaceTypeDTOParam param);

    TSafeSpaceTypeDTO findById(String id);

    List<TSafeSpaceTypeDTO> myList();
}
