package com.testor.module.duty.model.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;
import java.util.Map;
/**
 * 值班实体用于回显日历
 */
@Data
public class PersonDuty {
    @ApiModelProperty(value = "值班月id")
    private String id ;
    @ApiModelProperty(value = "流程状态")
    private String processStatus ;
    @ApiModelProperty(value = "状态：0正常 1删除 2停用")
    private String status ;
    @ApiModelProperty(value = "备注")
    private String remarks ;
    @ApiModelProperty(value = "值班日期", required = true)
    private String dutyDate ;
    @ApiModelProperty(value = "值班模式", required = true)
    private String dutyPattern ;
    @ApiModelProperty(value = "企业名称")
    private String companyName ;
    @ApiModelProperty(value = "租赁单位名称")
    private String tenantName ;
    @ApiModelProperty(value = "单位归属", required = true)
    private String unitBelong ;
    @ApiModelProperty(value = "调整原因")
    private String adjustCause ;
    @ApiModelProperty(value = "早班时间", required = true)
    private String morTime ;
    @ApiModelProperty(value = "中班时间", required = true)
    private String noonTime ;
    @ApiModelProperty(value = "晚班时间", required = true)
    private String lateTime ;
    @ApiModelProperty(value = "全天时间", required = true)
    private String allTime ;
    @ApiModelProperty(value = "添加值班人员信息")
    private List<Person> personList;
    @ApiModelProperty(value = "回显值班人信息")
    private Map<String, List<Person>> mapList;
}
