package com.testor.module.hazard.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.hazard.model.domain.TContractorAccessLog;
import com.testor.module.hazard.model.dto.TContractorAccessLogParam;
import com.testor.module.hazard.service.TContractorAccessLogService;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @Description: 承包商修改日志
 */
@RestController
@RequestMapping("/hazard/accessLog")
@Api(value = "TContractorAccessLog", tags = "承包商修改日志")
@Slf4j
public class TContractorAccessLogController extends SuperController{

    @Autowired
    private TContractorAccessLogService tContractorAccessLogService;

    @ApiOperation(value = "新增 承包商修改日志", notes = "Add TContractorAccessLog")
    @PostMapping(value = "/add")
    public BaseResponse<List<TContractorAccessLog>> addEntity(@RequestBody List<TContractorAccessLog> addRequest) {
        BaseResponse<List<TContractorAccessLog>> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(addRequest)) {
            List<TContractorAccessLog> result = tContractorAccessLogService.insertBatchContractorAccessLog(addRequest);
            baseResponse.setData(result);
        }
        return baseResponse;
    }

    @ApiOperation(value = "获取 承包商修改日志 分页列表", notes = "List THazardWorkPlan with page")
    @GetMapping(value = "/list")
    public  BaseResponse<BaseResponseList<TContractorAccessLog>>listEntity(TContractorAccessLogParam param){
        BaseResponse<BaseResponseList<TContractorAccessLog>>baseResponse=new BaseResponse<>();
        Page<TContractorAccessLog> tContractorAccessLogPage = tContractorAccessLogService.queryContractorAccessLog(param);
        BaseResponseList<TContractorAccessLog> baseResponseList=new BaseResponseList<>();
        baseResponseList.setData(tContractorAccessLogPage.getRecords());
        baseResponseList.setTotal(tContractorAccessLogPage.getTotal());
        baseResponse.setData(baseResponseList);
        return baseResponse;
    }


    @ApiOperation(value = "获取最大批次")
    @GetMapping(value = "/getMaxBatch")
    public  BaseResponse<String> getMaxBatch(@RequestParam String contractorAllowId){
        BaseResponse<String> baseResponse=new BaseResponse<>();
        String maxBatch = tContractorAccessLogService.getMaxBatch(contractorAllowId);
        baseResponse.setData(maxBatch);
        return baseResponse;
    }

}
