package com.testor.module.hazard.controller;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.hazard.model.domain.THazardWorkPlanCheck;
import com.testor.module.hazard.model.dto.*;
import com.testor.module.hazard.model.vo.HazardWorkPlanCheckComplianceStatisticsVO;
import com.testor.module.hazard.model.vo.HazardWorkPlanCheckProblemCountStatisticsVO;
import com.testor.module.hazard.model.vo.HazardWorkPlanCheckProblemTypeStatisticsVO;
import com.testor.module.hazard.service.THazardWorkPlanCheckService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * 危险作业计划监督检查统计Controller
 *
 * @author testor-framework
 * @date 2025-04-16 10:09:22
 */
@RestController
@RequestMapping("/hazard/checkStatistics")
@Api(value = "THazardWorkPlanCheckStatistics", tags = "危险作业计划监督检查统计")
@Slf4j
public class THazardWorkPlanCheckStatisticsController extends SuperController
{
    @Autowired
    private THazardWorkPlanCheckService tHazardWorkPlanCheckService;


	@ApiOperation(value = "企业总数,合规数,不合规数,问题数,合规企业数,合规比例 ")
	@GetMapping(value = "/selectHazardWorkPlanCheckStats")
	public BaseResponse<HazardWorkPlanCheckStatsDTO> selectHazardWorkPlanCheckStats(THazardWorkPlanCheckParam tHazardWorkPlanCheckParam){
		BaseResponse<HazardWorkPlanCheckStatsDTO> baseResponse=new BaseResponse<>();
		tHazardWorkPlanCheckParam.setUserId(getUserId());
		HazardWorkPlanCheckStatsDTO data= tHazardWorkPlanCheckService.selectHazardWorkPlanCheckStats(tHazardWorkPlanCheckParam);
		baseResponse.setData(data);
		return baseResponse;
	}

	@ApiOperation(value = "企业合规数")
	@GetMapping(value = "/enterpriseComplianceNumber")
	public BaseResponse<List<HazardWorkPlanCheckEnterpriseComplianceDto>> enterpriseComplianceNumber(THazardWorkPlanCheckParam tHazardWorkPlanCheckParam){
		BaseResponse<List<HazardWorkPlanCheckEnterpriseComplianceDto>> baseResponse=new BaseResponse<>();
		tHazardWorkPlanCheckParam.setUserId(getUserId());
		List<HazardWorkPlanCheckEnterpriseComplianceDto> data= tHazardWorkPlanCheckService.enterpriseComplianceNumber(tHazardWorkPlanCheckParam);
		baseResponse.setData(data);
		return baseResponse;
	}

	@ApiOperation(value = "问题数量统计")
	@GetMapping(value = "/selectProblemCountStatistics")
	public BaseResponse<List<HazardWorkPlanCheckProblemCountStatisticsVO>> selectProblemCountStatistics(THazardWorkPlanCheckParam tHazardWorkPlanCheckParam){
		BaseResponse<List<HazardWorkPlanCheckProblemCountStatisticsVO>> baseResponse=new BaseResponse<>();
		tHazardWorkPlanCheckParam.setUserId(getUserId());
		List<HazardWorkPlanCheckProblemCountStatisticsVO> data= tHazardWorkPlanCheckService.selectProblemCountStatistics(tHazardWorkPlanCheckParam);
		baseResponse.setData(data);
		return baseResponse;
	}

	@ApiOperation(value = "企业合规率")
	@GetMapping(value = "/corporateComplianceRate")
	public BaseResponse<BaseResponseList<HazardWorkPlanCheckProblemCountStatisticsVO>> corporateComplianceRate(THazardWorkPlanCheckParam tHazardWorkPlanCheckParam){
		BaseResponse<BaseResponseList<HazardWorkPlanCheckProblemCountStatisticsVO>>baseResponse=new BaseResponse<>();
		tHazardWorkPlanCheckParam.setUserId(getUserId());
		Page<HazardWorkPlanCheckProblemCountStatisticsVO> resultList= tHazardWorkPlanCheckService.corporateComplianceRate(tHazardWorkPlanCheckParam);
		BaseResponseList<HazardWorkPlanCheckProblemCountStatisticsVO> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList.getRecords());
		baseResponseList.setTotal(resultList.getTotal());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}




}
