package com.testor.module.hazard.model.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum LicenseSignatureTypeEnum {
    TYPE_1("1", "作业所在部门"),
    TYPE_2("2", "作业主管部门"),
    TYPE_3("3", "安全管理部门"),
    TYPE_4("4", "主管部门负责人"),
    TYPE_5("5", "公司级分管领导负责人"),
    TYPE_6("6", "公司级安环部"),
    TYPE_7("7", "安全分管领导或主要负责人"),
    TYPE_8("8", "分管安全负责人");

    private String type;
    private String desc;

    public static LicenseSignatureTypeEnum getByCode(String type) {
        for (LicenseSignatureTypeEnum licenseSignatureTypeEnum : LicenseSignatureTypeEnum.values()) {
            if (licenseSignatureTypeEnum.getType().equals(type)) {
                return licenseSignatureTypeEnum;
            }
        }
        return null;
    }
}
