package com.testor.module.hazard.model.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum LicenseStatusEnum {



    WORK_DEPARTMENT("1", "作业所在部门审批"),
    SUPERVISING_DEPARTMENT("2","作业主管部门审批"),
    SAFETY_MANAGEMENT_DEPARTMENT("3","安全管理部门审批"),
    DEPARTMENT_HEAD("4","主管部门负责人审批"),
    RESPONSIBLE_LEADER("5","公司级分管领导负责人审批"),
    SAFETY_ENVIRONMENT_DEPARTMENT("6","公司级安环部审批"),
    PRIMARY_RESPONSIBLE("7","安全分管领导或企业主要负责人签字"),
    SAFETY_IN_CHARGE("8","分管安全负责人签字"),
    ON_SITE_CONFIRMATION("9","现场确认"),
    POWER_SUPPLY("10","供电单位签字"),
    MAIN_PERSON_CHARGE("11","企业主要负责人签字"),
    SAFETY_DEPARTMENT("12","安全部门签字");
    private final String value; // 状态值
    private final String description; // 状态描述

    /**
     * 根据状态值获取枚举
     *
     * @param value 状态值
     * @return 对应的枚举，如果没有找到则返回 null
     */
    public static LicenseStatusEnum fromValue(String value) {
        for (LicenseStatusEnum status : values()) {
            if (status.value.equals(value)) {
                return status;
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return this.value + " - " + this.description;
    }

}
