package com.testor.module.hazard.model.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum WorkPlanStatusEnum {
    /**
     * 草稿
     */
    DRAFT("0", "草稿"),

    /**
     * 作业前（风险分析）
     */
    RISK_ANALYSIS("1", "作业前（风险分析）"),

    /**
     * 作业前（条件确认）
     */
    CONDITION_CONFIRMATION("2", "作业前（条件确认）"),

    /**
     * 作业前（许可证）
     */
    PERMIT("3", "作业前（许可证）"),

    /**
     * 技术交底
     */
    TECHNICAL_EXPLANATION("4", "技术交底"),

    /**
     * 已关闭
     */
    CLOSED("5", "已关闭"),

    /**
     * 已取消
     */
    CANCELED("6", "已取消"),

    /**
     * 已超时
     */
    OVERDUE("7", "已超时"),

    /**
     * 驳回
     */
    REJECTED("8", "驳回"),

    /**
     * 审批中
     */
    UNDER_APPROVAL("9", "审批中"),

    /**
     * 进行中
     */
    IN_PROGRESS("10", "进行中"),


    TO_BE_CLOSED("11", "待安全许可证关闭"),

    TIMEOUT_CANCELED("12", "已超时自动取消");

    private final String value; // 状态值
    private final String description; // 状态描述

    /**
     * 根据状态值获取枚举
     *
     * @param value 状态值
     * @return 对应的枚举，如果没有找到则返回 null
     */
    public static WorkPlanStatusEnum fromValue(String value) {
        for (WorkPlanStatusEnum status : values()) {
            if (status.value.equals(value)) {
                return status;
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return this.value + " - " + this.description;
    }
}
