package com.testor.module.partner.model.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.testor.module.partner.model.domain.TPartnerCertificate;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;


/**
 * 相关方组织机构对象 t_partner_org
 *
 * @author testor-framework
 * @date 2022-06-01 14:16:53
 */
@Data
@ApiModel(value = "相关方组织机构详情对象", description = "")
public class PartnerOrgDetailVO extends SuperModel {

    @ApiModelProperty(value = "负责绑定id")
    private String resId;

    @ApiModelProperty(value = "相关方id")
    private String partnerId;

    @ApiModelProperty(value = "相关方单位名称")
    private String partnerName;

    @ApiModelProperty(value = "社会信用编码")
    private String creditCode;

    @ApiModelProperty(value = "法定代表人")
    private String legalPerson;

    @ApiModelProperty(value = "类型")
    private String typeName;

    @ApiModelProperty(value = "现场负责人")
    private String responsiblePerson;

    @ApiModelProperty(value = "联系方式")
    private String phone;
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "合同日期")
    private Date contractStartDate;
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "合同日期")
    private Date contractEndDate;

    @ApiModelProperty(value = "资质状态（0-异常，1-正常）,默认1", example = "1")
    private Integer certificateStatus;

    @ApiModelProperty(value = "是否为黑名单（0-否，1-是）,默认 0")
    private String isBlacklist;

    @ApiModelProperty("资质")
    private List<TPartnerCertificate> tPartnerCertificates;

    @ApiModelProperty("黑名单原因")
    private String blacklistReason;

}
