/* Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.testor.workflow.form.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.flowable.idm.api.User;

import java.io.Serializable;
import java.util.List;

/**
 * @author sj 流程表单
 */
@Data
public class ZFormDTO implements Serializable {

    @ApiModelProperty(value = "formId")
    private String id;
    @ApiModelProperty(required = true, value = "表单名称")
    private String name;
    @ApiModelProperty(required = true, value = "表单key,唯一值")
    private String key;
    @ApiModelProperty(value = "描述")
    private String description;
    @ApiModelProperty(value = "表单项")
    private List<ZFormItemDTO> formItemList;

    @ApiModelProperty(value = "类型，默认2，不用管", hidden = true)
    private Integer modelType = 2;

    @ApiModelProperty(value = "操作用户", hidden = true)
    private User user;
}
