/*
 * Decompiled with CFR 0.152.
 */
package com.testor.biz.sys.log.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.testor.biz.sys.log.LogEnumCode;
import com.testor.biz.sys.log.dao.SysLogDao;
import com.testor.biz.sys.log.model.domain.SysLog;
import com.testor.biz.sys.log.service.SysLogService;
import com.testor.biz.sys.org.model.domain.SysOrg;
import com.testor.biz.sys.org.service.SysOrgService;
import com.testor.biz.sys.resource.model.domain.SysResource;
import com.testor.biz.sys.resource.service.SysResourceService;
import com.testor.biz.sys.user.model.domain.SysUser;
import com.testor.biz.sys.user.service.SysUserService;
import com.tongtech.tfw.backend.common.constants.enumeration.HttpStatusCodeEnum;
import com.tongtech.tfw.backend.common.jwt.JwtHelper;
import com.tongtech.tfw.backend.common.models.jwt.JwtInfos;
import com.tongtech.tfw.backend.common.models.response.FailedResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import com.tongtech.tfw.backend.common.request.RequestUtil;
import com.tongtech.tfw.backend.common.response.ResponseWrapper;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.json.JacksonHelper;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class SysLogServiceImpl
extends SuperServiceImpl<SysLogDao, SysLog>
implements SysLogService {
    private final SysUserService sysUserService;
    private final SysOrgService sysOrgService;
    private final SysResourceService sysResourceService;

    public SysLogServiceImpl(SysUserService sysUserService, SysOrgService sysOrgService, SysResourceService sysResourceService) {
        this.sysUserService = sysUserService;
        this.sysOrgService = sysOrgService;
        this.sysResourceService = sysResourceService;
    }

    public void saveLog(HttpServletRequest request, ResponseWrapper response, Object result) throws Exception {
        SysLog sysLog = new SysLog();
        sysLog.setId(IdHelper.getId32bit());
        sysLog.setUri((String)request.getAttribute("url"));
        String contentPath = request.getContextPath();
        String url = StringHelper.removePrefix((CharSequence)sysLog.getUri(), (CharSequence)contentPath);
        SysResource sysResource = (SysResource)((Object)this.sysResourceService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().select(new SFunction[]{SysResource::getResourceId, SysResource::getResourceName, SysResource::getParentIds}).eq(SysResource::getResourceUrl, (Object)url)).eq(SuperModel::getStatus, (Object)"0")).last("LIMIT 1"), false));
        if (ObjectHelper.isNotEmpty((Object)((Object)sysResource))) {
            String[] parents;
            StringBuilder actionName = new StringBuilder();
            for (String pid : parents = StringHelper.split((String)sysResource.getParentIds(), (String)",")) {
                if ("0".equals(pid)) continue;
                actionName.append(((SysResource)((Object)this.sysResourceService.getById((Serializable)((Object)pid)))).getResourceName()).append("-");
            }
            actionName.append(sysResource.getResourceName());
            sysLog.setActions(actionName.toString());
        } else {
            sysLog.setActions(url);
        }
        sysLog.setIp(RequestUtil.getIpAddr((HttpServletRequest)request));
        sysLog.setMethod((String)request.getAttribute("method"));
        sysLog.setStatus("0");
        sysLog.setOpTime(LocalDateTime.now());
        sysLog.setUser("Unknown");
        sysLog.setDept("Unknown");
        sysLog.setCreateBy("Unknown");
        sysLog.setCreateDate(LocalDateTime.now());
        String authorization = request.getHeader("Authorization");
        JwtInfos jwtInfos = JwtHelper.parseJwtAuth0((String)authorization, (String)"Token Issuer");
        if (StringUtils.isNotBlank((CharSequence)jwtInfos.getUserId())) {
            String userId = jwtInfos.getUserId();
            sysLog.setCreateBy(userId);
            SysUser sysUser = (SysUser)((Object)this.sysUserService.getById((Serializable)((Object)userId)));
            if (ObjectHelper.isNotEmpty((Object)((Object)sysUser))) {
                sysLog.setUser(sysUser.getUserName());
                SysOrg sysOrg = (SysOrg)((Object)this.sysOrgService.getById((Serializable)((Object)sysUser.getOrgId())));
                StringBuilder orgName = new StringBuilder();
                if (ObjectHelper.isNotEmpty((Object)((Object)sysOrg))) {
                    String[] parents;
                    for (String pid : parents = StringHelper.split((String)sysOrg.getParentIds(), (String)",")) {
                        if ("0".equals(pid)) continue;
                        orgName.append(((SysOrg)((Object)this.sysOrgService.getById((Serializable)((Object)pid)))).getOrgName()).append("-");
                    }
                    orgName.append(sysOrg.getOrgName());
                    sysLog.setDept(orgName.toString());
                } else {
                    sysLog.setDept(sysUser.getOrgId());
                }
            } else {
                sysLog.setUser(userId);
            }
        }
        if (result instanceof FailedResponse) {
            FailedResponse failedResponse = (FailedResponse)result;
            if (HttpStatusCodeEnum.OK.code() == failedResponse.getCode().intValue()) {
                sysLog.setType(new BigDecimal(LogEnumCode.OPERATION.code()));
            } else {
                sysLog.setType(new BigDecimal(LogEnumCode.OTHER.code()));
            }
            sysLog.setMsg(JacksonHelper.toJson((Object)result));
        } else {
            sysLog.setType(new BigDecimal(LogEnumCode.OPERATION.code()));
            if (sysLog.getUri().contains("/auth/login")) {
                sysLog.setType(new BigDecimal(LogEnumCode.LOGGING.code()));
            }
        }
        this.save((Object)sysLog);
    }
}

