package com.testor.ddd.safetyControl.infrastructure.repository.riskOwner.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;


/**
 * 管控部门责任人对象 t_safe_risk_owner
 * 
 * @author testor-framework
 * @date 2022-07-11 10:00:09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_safe_risk_owner")
@ApiModel(value = "TSafeRiskOwner对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TSafeRiskOwnerDO extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * id
 */
  @ApiModelProperty(value = "id")
  @TableId(value = "id",type = IdType.ASSIGN_UUID)
  private String id;
/**
 * 风险源或风险点 id
 */
  @ApiModelProperty(value = "风险源或风险点 id")

  @TableField("risk_id")
  private String riskId;
/**
 * 用户id
 */
  @ApiModelProperty(value = "用户id")

  @TableField("user_id")
  private String userId;

  /**
   * 组织机构id
   */
  @ApiModelProperty(value = "组织机构id")

  @TableField("org_id")
  private String orgId;
  /**
   * 部门id
   */
  @ApiModelProperty(value = "部门id")

  @TableField("department_id")
  private String departmentId;

/**
 * 1-危险源；2-风险点（风险分级）
 */
  @ApiModelProperty(value = "1-危险源；2-风险点（风险分级）" , example = "0")

  @TableField("type")
  private Integer type;

  public static final String ID ="id";
  public static final String RISK_ID ="risk_id";
  public static final String USER_ID ="user_id";
  public static final String TYPE ="type";


}
