package com.testor.module.contractor.ledger.controller;

import java.util.ArrayList;
import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.testor.module.contractor.ledger.model.domain.TContractorContract;
import com.testor.module.contractor.ledger.model.domain.TContractorInfo;
import com.testor.module.contractor.ledger.model.dto.LedgerTypeVo;
import com.testor.module.contractor.ledger.model.dto.TContractorLedgerDto;
import com.testor.module.contractor.ledger.service.TContractorContractService;
import com.testor.module.contractor.ledger.service.TContractorInfoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import lombok.extern.slf4j.Slf4j;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RestController;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;

import com.testor.module.contractor.ledger.model.domain.TContractorLedger;
import com.testor.module.contractor.ledger.model.dto.TContractorLedgerParam;
import com.testor.module.contractor.ledger.model.dto.TContractorLedgerDelParam;
import com.testor.module.contractor.ledger.service.TContractorLedgerService;

/**
 * 承包商台账Controller
 *
 * @author testor-framework
 * @date 2024-11-19 10:01:42
 */
@RestController
@RequestMapping("/contractor/ledger")
@Api(value = "TContractorLedger", tags = "承包商台账")
@Slf4j
public class TContractorLedgerController extends SuperController
{
    @Autowired
    private TContractorLedgerService tContractorLedgerService;

    /* Generated Method*/
	@ApiOperation(value = "新增 承包商台账", notes = "Add TContractorLedger")
	@PostMapping(value = "/add")
	@Transactional(rollbackFor = Exception.class)
	public BaseResponse<TContractorLedger>addEntity(@RequestBody TContractorLedgerDto addRequest) {
		BaseResponse<TContractorLedger> baseResponse=new BaseResponse<>();
		TContractorLedger result =  tContractorLedgerService.addContractorLedger(addRequest);
		baseResponse.setData(result);
		return baseResponse;
	}

	@ApiOperation(value = "获取 承包商台账 ", notes = "Get TContractorLedger By Id")
	@GetMapping(value = "/get")
	public BaseResponse<TContractorLedgerDto> getById(String id){
		BaseResponse<TContractorLedgerDto> baseResponse=new BaseResponse<>();
		if (StringHelper.isEmpty(id)) {
			baseResponse.setCode(400);
			baseResponse.setMsg("ID 不能为空");
			return baseResponse;
		}
		//获取台账信息
		TContractorLedgerDto ledgerDto = tContractorLedgerService.getLedgerById(id);
		if (ledgerDto == null) {
			baseResponse.setCode(400);
			baseResponse.setMsg("未找到对应的承包商台账信息");
			return baseResponse;
		}
		baseResponse.setData(ledgerDto);
		return baseResponse;
	}

	@ApiOperation(value = "修改 承包商台账 ", notes = "Update TContractorLedger By Id")
	@PutMapping(value = "/update")
	public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody TContractorLedgerDto updateRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(updateRequest)&&StringHelper.isNotEmpty(updateRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常

			TContractorLedger result= tContractorLedgerService.updateEntity(updateRequest);

			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "删除 承包商台账 ", notes = "delete TContractorLedger By Id")
	@PutMapping(value = "/delete")
	public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TContractorLedgerDelParam deleteRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(deleteRequest)&&StringHelper.isNotEmpty(deleteRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TContractorLedger data= new TContractorLedger();
			data.setId(deleteRequest.getId());
			data.setStatus(BizConstants.STATUS_DELETE);
			boolean result= tContractorLedgerService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "批量删除承包商台账", notes = "delete TContractorLedger by batch Id")
	@PutMapping(value = "/batch_delete")
	public BaseResponse<BizGeneralResponse> deleteEntityBatch(
			@RequestBody TContractorLedgerDelParam deleteRequest) {
		BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
		if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            /* 批量删除 */
			List<TContractorLedger> tContractorLedgerList = new ArrayList<>();
            for(String id: deleteRequest.getIds()){
                TContractorLedger data= new TContractorLedger();
				data.setId(id);
				data.setStatus(BizConstants.STATUS_DELETE);
                tContractorLedgerList.add(data);
			}
			boolean result = tContractorLedgerService.updateBatchById(tContractorLedgerList);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 承包商台账 分页列表", notes = "List TContractorLedger with page")
	@GetMapping(value = "/list")
	public  BaseResponse<BaseResponseList<TContractorLedger>>listEntity(TContractorLedgerParam param) {
		BaseResponse<BaseResponseList<TContractorLedger>> baseResponse = new BaseResponse<>();
		Page<TContractorLedger> resultList = tContractorLedgerService.pageList(param);
		BaseResponseList<TContractorLedger> baseResponseList = new BaseResponseList<>();
		baseResponseList.setData(resultList.getRecords());
		baseResponseList.setTotal(resultList.getTotal());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

	@ApiOperation(value = "获取 承包商台账 分页列表", notes = "List TContractorLedger with page")
	@GetMapping(value = "/getType")
	public  BaseResponse<List<LedgerTypeVo>>getLedgerTypeVo(TContractorLedgerParam param) {
		BaseResponse<List<LedgerTypeVo>> baseResponse = new BaseResponse<>();
		List<LedgerTypeVo> LedgerTypeVos = tContractorLedgerService.getLedgerTypeVo(param);
		baseResponse.setData(LedgerTypeVos);
		return baseResponse;
	}
}
