package com.testor.module.contractor.manage.model.dto;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.contractor.ledger.model.dto.TContractorLedgerDto;
import com.testor.module.contractor.manage.model.domain.TContractorAllowPerson;
import com.testor.module.contractor.manage.model.domain.TContractorPreparation;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel(value = "TContractorConditionReviewDetail聚合对象",description = "用于审查内容查看信息的聚合对象")
public class ConditionReviewContentDto{
    @ApiModelProperty(value = "合同信息、承包商资质等，对应审查内容code为C01,C02,C04,C07")
    private TContractorLedgerDto contractorLedger;

    @ApiModelProperty(value = "入厂人员信息、人员保险信息分页列表，对应审查内容code为C03,C05,C11")
    private Page<TContractorAllowPerson> personPage;

    @ApiModelProperty(value = "开工准备信息，对应审查内容code为C08,C09,C10")
    private TContractorPreparation preparation;

    @ApiModelProperty(value = "特种作业人员作业证，对应审查内容code为C06")
    private Page<ConditionReviewPersonCertificateDto> personCertificatePage;

}
