package com.testor.module.emergency.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.emergency.model.domain.TContingencyPlan;
import com.testor.module.emergency.model.domain.TContingencyPlanRecord;
import com.testor.module.emergency.model.dto.TContingencyPlanDTO;
import com.testor.module.emergency.model.dto.TContingencyPlanParam;
import com.testor.module.emergency.model.vo.TContingency;
import com.testor.module.emergency.model.vo.TContingencyPlanRecordVO;
import com.testor.module.emergency.model.vo.TContingencyPlanVO;
import com.tongtech.tfw.backend.common.models.supers.SuperService;

import java.util.List;

/**
 * 应急预案Service接口
 * 
 * @author testor-framework
 * @date 2022-10-18 09:50:43
 */
public interface TContingencyPlanService extends SuperService<TContingencyPlan> {

    /**
     * 添加实体
     *
     * @param tContingencyPlanDTO t应急计划dto
     * @return {@link Boolean}
     */
    Boolean addEntity(TContingencyPlanDTO tContingencyPlanDTO);

    /**
     * 获取详情
     *
     * @param id id
     * @return {@link TContingency}
     */
    TContingency getParticulars(String id);

    /**
     * @param param 参数
     * @return {@link Page}<{@link TContingencyPlanVO}>
     */
    Page<TContingencyPlanVO> pageList(TContingencyPlanParam param);

    /**
     * 获取修订记录
     *
     * @param id id
     * @return {@link List}<{@link TContingencyPlanRecord}>
     */
    List<TContingencyPlanRecordVO> getEditHistory(String id);

    List<TContingencyPlanVO> listEntity(String accidentKey);

}
