package com.testor.module.emergency.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.emergency.model.domain.TEmergencyGoods;
import com.testor.module.emergency.model.dto.TEmergencyGoodsDTO;
import com.testor.module.emergency.model.dto.TEmergencysDTO;
import com.testor.module.emergency.model.vo.TEmergencyGoodsVO;
import com.testor.module.emergency.model.vo.TEmergencyVO;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperService;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 应急物资Service接口
 * 
 * @author testor-framework
 * @date 2022-10-08 17:31:31
 */
public interface TEmergencyGoodsService extends SuperService<TEmergencyGoods> {

    /**
     * 添加物资信息
     *
     * @param tEmergencysDTO t紧急dto
     * @return {@link Boolean}
     */
    Boolean addEntity(TEmergencysDTO tEmergencysDTO);

    /**
     * 更新实体
     *
     * @param tEmergencysDTO t紧急dto
     * @return boolean
     */
    boolean updateEntity(TEmergencysDTO tEmergencysDTO);

    /**
     * 删除物资
     *
     * @param id id
     * @return boolean
     */
    boolean deleteEntity(String id);

    /**
     * 物质详情
     *
     * @param id id
     * @return {@link TEmergencyVO}
     */
    TEmergencyVO getParticulars(String id);

    /**
     * 分页查询
     *
     * @param tEmergencyGoodsDTO t紧急货物dto
     * @return {@link List}<{@link TEmergencyGoodsVO}>
     */
    Page<TEmergencyGoodsVO> pages(TEmergencyGoodsDTO tEmergencyGoodsDTO);

    /**
     * 导入应急物资
     *
     * @param file 文件
     * @return {@link BaseResponse}<{@link String}>
     */
    BaseResponse<String> importGoods(MultipartFile file);

    void exportGoods(HttpServletResponse response, TEmergencyGoodsDTO tEmergencyGoodsDTO);

    Boolean confirmSpotChecks(String id);
}
