package com.testor.module.hazard.controller;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import lombok.extern.slf4j.Slf4j;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RestController;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.exceptions.ApiException;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;

import com.testor.module.hazard.model.domain.THazardLicenseSignatureRecord;
import com.testor.module.hazard.model.dto.THazardLicenseSignatureRecordParam;
import com.testor.module.hazard.model.dto.THazardLicenseSignatureRecordDelParam;
import com.testor.module.hazard.service.THazardLicenseSignatureRecordService;

/**
 * 危险作业许可证-签字记录Controller
 *
 * @author testor-framework
 * @date 2024-12-26 10:53:14
 */
@RestController
@RequestMapping("/hazard/licenseRecord")
@Api(value = "THazardLicenseSignatureRecord", tags = "危险作业许可证-签字记录")
@Slf4j
public class THazardLicenseSignatureRecordController extends SuperController
{
    @Autowired
    private THazardLicenseSignatureRecordService tHazardLicenseSignatureRecordService;

    /* Generated Method*/
	@ApiOperation(value = "新增 危险作业许可证-签字记录", notes = "Add THazardLicenseSignatureRecord")
	@PostMapping(value = "/add")
	public BaseResponse<THazardLicenseSignatureRecord>addEntity(@RequestBody THazardLicenseSignatureRecord addRequest) {
		BaseResponse<THazardLicenseSignatureRecord> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(addRequest)){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
			String id = IdHelper.getId32bit();
            THazardLicenseSignatureRecord data=BeanHelper.beanToBean(addRequest,  THazardLicenseSignatureRecord.class);
			data.setId(id);
			boolean result= tHazardLicenseSignatureRecordService.save(data);
			if(result){
                THazardLicenseSignatureRecord newEntity = new THazardLicenseSignatureRecord();
				newEntity.setId(id);
				baseResponse.setData(newEntity);
			}
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 危险作业许可证-签字记录 ", notes = "Get THazardLicenseSignatureRecord By Id")
	@GetMapping(value = "/get")
	public BaseResponse<THazardLicenseSignatureRecord> getById(String id){
		BaseResponse<THazardLicenseSignatureRecord> baseResponse=new BaseResponse<>();
		if(StringHelper.isNotEmpty(id)){
			// TODO 按需求添加业务异常判断
            THazardLicenseSignatureRecord data= tHazardLicenseSignatureRecordService.getById(id);
			baseResponse.setData(data);
		}
		return baseResponse;
	}

	@ApiOperation(value = "修改 危险作业许可证-签字记录 ", notes = "Update THazardLicenseSignatureRecord By Id")
	@PutMapping(value = "/update")
	public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody THazardLicenseSignatureRecord updateRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(updateRequest)&&StringHelper.isNotEmpty(updateRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            THazardLicenseSignatureRecord data=BeanHelper.beanToBean(updateRequest, THazardLicenseSignatureRecord.class);
			boolean result= tHazardLicenseSignatureRecordService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "删除 危险作业许可证-签字记录 ", notes = "delete THazardLicenseSignatureRecord By Id")
	@PutMapping(value = "/delete")
	public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody THazardLicenseSignatureRecordDelParam deleteRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(deleteRequest)&&StringHelper.isNotEmpty(deleteRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            THazardLicenseSignatureRecord data= new THazardLicenseSignatureRecord();
			data.setId(deleteRequest.getId());
			data.setStatus(BizConstants.STATUS_DELETE);
			boolean result= tHazardLicenseSignatureRecordService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "批量删除危险作业许可证-签字记录", notes = "delete THazardLicenseSignatureRecord by batch Id")
	@PutMapping(value = "/batch_delete")
	public BaseResponse<BizGeneralResponse> deleteEntityBatch(
			@RequestBody THazardLicenseSignatureRecordDelParam deleteRequest) {
		BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
		if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            /* 批量删除 */
			List<THazardLicenseSignatureRecord> tHazardLicenseSignatureRecordList = new ArrayList<>();
            for(String id: deleteRequest.getIds()){
                THazardLicenseSignatureRecord data= new THazardLicenseSignatureRecord();
				data.setId(id);
				data.setStatus(BizConstants.STATUS_DELETE);
                tHazardLicenseSignatureRecordList.add(data);
			}
			boolean result = tHazardLicenseSignatureRecordService.updateBatchById(tHazardLicenseSignatureRecordList);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 危险作业许可证-签字记录 分页列表", notes = "List THazardLicenseSignatureRecord with page")
	@GetMapping(value = "/list")
	public  BaseResponse<BaseResponseList<THazardLicenseSignatureRecord>>listEntity(THazardLicenseSignatureRecordParam param){
		BaseResponse<BaseResponseList<THazardLicenseSignatureRecord>>baseResponse=new BaseResponse<>();
		Long page=
				StringHelper.isEmpty(param.getPage())?BizConstants.PAGE:Long.valueOf(param.getPage());
		Long limit=
				StringHelper.isEmpty(param.getLimit())?BizConstants.LIMIT:Long.valueOf(param.getLimit());
		Page<THazardLicenseSignatureRecord> resultPage=new Page<>(page,limit);
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<THazardLicenseSignatureRecord> queryWrapper=this.createQuery(param);
		Page<THazardLicenseSignatureRecord> resultList= tHazardLicenseSignatureRecordService.page(resultPage,queryWrapper);
		BaseResponseList<THazardLicenseSignatureRecord> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList.getRecords());
		baseResponseList.setTotal(resultList.getTotal());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}


	@ApiOperation(value = "获取 危险作业许可证-签字记录 列表", notes = "List THazardLicenseSignatureRecord all")
	@GetMapping(value = "/getLatestByPlanIdAndType")
	public  BaseResponse<BaseResponseList<THazardLicenseSignatureRecord>>getLatestByPlanIdAndType(THazardLicenseSignatureRecord param){
		BaseResponse<BaseResponseList<THazardLicenseSignatureRecord>>baseResponse=new BaseResponse<>();
		List<THazardLicenseSignatureRecord> resultList=tHazardLicenseSignatureRecordService.getLatestByPlanIdAndType(param);
		BaseResponseList<THazardLicenseSignatureRecord> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList);
		baseResponseList.setTotal(resultList.size());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

	@ApiOperation(value = "获取 危险作业许可证-签字记录 列表", notes = "List THazardLicenseSignatureRecord all")
	@GetMapping(value = "/datas")
	public  BaseResponse<BaseResponseList<THazardLicenseSignatureRecord>>listAllEntity(THazardLicenseSignatureRecordParam param){
		BaseResponse<BaseResponseList<THazardLicenseSignatureRecord>>baseResponse=new BaseResponse<>();
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<THazardLicenseSignatureRecord> queryWrapper=this.createQuery(param);

		List<THazardLicenseSignatureRecord> resultList=tHazardLicenseSignatureRecordService.list(queryWrapper);
		BaseResponseList<THazardLicenseSignatureRecord> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList);
		baseResponseList.setTotal(resultList.size());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

    /* Private Methods */
	/**
     * 列表查询条件及查询参数
     */
	private QueryWrapper<THazardLicenseSignatureRecord> createQuery(THazardLicenseSignatureRecordParam queryParam){
		QueryWrapper<THazardLicenseSignatureRecord> queryWrapper=new QueryWrapper<>();
		if(StringHelper.isNotEmpty(queryParam.getPlanId())){
			queryWrapper.eq(THazardLicenseSignatureRecord.PLAN_ID,queryParam.getPlanId());
		}
		if(StringHelper.isNotEmpty(queryParam.getLicenseId())){
			queryWrapper.eq(THazardLicenseSignatureRecord.LICENSE_ID,queryParam.getLicenseId());
		}
		if(StringHelper.isNotEmpty(queryParam.getType())){
			queryWrapper.eq(THazardLicenseSignatureRecord.TYPE,queryParam.getType());
		}
		if(StringHelper.isNotEmpty(queryParam.getSignatory())){
			queryWrapper.eq(THazardLicenseSignatureRecord.SIGNATORY,queryParam.getSignatory());
		}
		if(StringHelper.isNotEmpty(queryParam.getSignature())){
			queryWrapper.eq(THazardLicenseSignatureRecord.SIGNATURE,queryParam.getSignature());
		}
		if(StringHelper.isNotEmpty(queryParam.getSignatureLocation())){
			queryWrapper.eq(THazardLicenseSignatureRecord.SIGNATURE_LOCATION,queryParam.getSignatureLocation());
		}
		if(ObjectHelper.isNotEmpty(queryParam.getSignatureDate())){
			queryWrapper.eq(THazardLicenseSignatureRecord.SIGNATURE_DATE,queryParam.getSignatureDate());
		}
		if (StringHelper.isNotEmpty(queryParam.getStatus())) {
			queryWrapper.eq(THazardLicenseSignatureRecord.STATUS, queryParam.getStatus());
		} else {
			queryWrapper.ne(THazardLicenseSignatureRecord.STATUS, BizConstants.STATUS_DELETE);
		}
		if (StringHelper.isNotEmpty(queryParam.getOrderBy())){
			if(StringHelper.isNotEmpty(queryParam.getOrderType())
					&&BizConstants.ASC.equals(queryParam.getOrderType())){
				queryWrapper.orderByAsc(queryParam.getOrderBy());
			}else{
				queryWrapper.orderByDesc(queryParam.getOrderBy());
			}
		}else{
			queryWrapper.orderByDesc(THazardLicenseSignatureRecord.UPDATE_DATE);
		}
		return queryWrapper;
	}
}
