package com.testor.module.hazard.model.dto;

import com.testor.module.hazard.model.domain.TContractorAccessLog;
import com.testor.module.hazard.model.domain.THazardWorkPlan;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 危险作业计划 删除参数对象
 *
 * @author testor-framework
 * @date 2024-12-19 10:39:26
 */

@Data
@ApiModel(value = "THazardWorkPlan 列表查询参数对象")
@EqualsAndHashCode(callSuper = true)
public class TContractorAccessLogParam extends TContractorAccessLog {
	private static final long serialVersionUID = 1L;
	@ApiModelProperty(value = "每页数量")
	private String limit;

	@ApiModelProperty(value = "当前页数")
	private String page;

	@ApiModelProperty(value = "排序字段")
	private String orderBy;

	@ApiModelProperty(value = "排序方式")
	private String orderType;

}
