package com.testor.module.production.model.dto;

import com.testor.module.production.model.domain.TProductionAccident;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 安全生产事故配置 删除参数对象
 *
 * @author testor-framework
 * @date 2022-11-17 11:37:56
 */

@Data
@ApiModel(value = "TProductionAccident 列表查询参数对象")
@EqualsAndHashCode(callSuper = true)
public class TProductionAccidentParam extends TProductionAccident {
	private static final long serialVersionUID = 1L;
	@ApiModelProperty(value = "每页数量")
	private String limit;

	@ApiModelProperty(value = "当前页数")
	private String page;

	@ApiModelProperty(value = "排序字段")
	private String orderBy;

	@ApiModelProperty(value = "排序方式")
	private String orderType;

	@ApiModelProperty(value = "企业选择")
	private List<String> companyIds;

}
