package com.testor.module.report.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.biz.sys.org.model.domain.SysOrg;
import com.testor.biz.sys.org.service.SysOrgService;
import com.testor.common.util.ConverUtils;
import com.testor.common.util.FileUtil;
import com.testor.module.duty.model.domain.TSysDutyLog;
import com.testor.module.duty.model.domain.TSysTaskWork;
import com.testor.module.duty.model.dto.TSysDutyLogParam;
import com.testor.module.duty.service.TSysDutyLogService;
import com.testor.module.duty.service.TSysTaskWorkService;
import com.testor.module.partner.model.domain.TPartnerStaff;
import com.testor.module.partner.service.TPartnerStaffService;
import com.testor.module.train.exam.model.domain.TTrainExamChoice;
import com.testor.module.train.exam.model.domain.TTrainExamJudgment;
import com.testor.module.train.exam.model.domain.TTrainQuestionBank;
import com.testor.module.train.exam.model.domain.TTrainTestQuestions;
import com.testor.module.train.exam.service.TTrainExamChoiceService;
import com.testor.module.train.exam.service.TTrainExamJudgmentService;
import com.testor.module.train.exam.service.TTrainQuestionBankService;
import com.testor.module.train.exam.service.TTrainTestQuestionsService;
import com.testor.module.train.paper.model.domain.TTrainPaper;
import com.testor.module.train.paper.model.dto.*;
import com.testor.module.train.paper.service.TTrainPaperService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.context.ContextUtils;
import com.tongtech.tfw.backend.common.exception.BusinessException;
import com.tongtech.tfw.backend.common.models.sys.UserInfo;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import freemarker.template.Configuration;
import freemarker.template.Template;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.SneakyThrows;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.Zip64Mode;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Consumer;
import java.util.stream.Collectors;

@Controller
@RequestMapping("/freemarker")
@Api(value = "TTrainPaper", tags = "freemarker模板统一下载")
public class FreemarkerController {
    @Autowired
    private SysOrgService sysOrgService;
    @Autowired
    private Configuration configuration;
    @Autowired
    private TSysDutyLogService tSysDutyLogService;
    @Autowired
    private TSysTaskWorkService tSysTaskWorkService;
    @Resource
    private HttpServletResponse response;
    @Autowired
    private TTrainTestQuestionsService tTrainTestQuestionsService;
    @Autowired
    private TTrainPaperService tTrainPaperService;
    @Autowired
    private TTrainExamChoiceService tTrainExamChoiceService;
    @Autowired
    private TTrainExamJudgmentService tTrainExamJudgmentService;
    @Autowired
    private TTrainQuestionBankService tTrainQuestionBankService;

    @Autowired
    private TPartnerStaffService staffService;

    @Value("${ureport.path}")
    private String path;

    @Value("${minio.imgInport}")
    private String imgInport;

    @Value("${minio.path}")
    private String addr;

    @Resource
    private HttpServletRequest request;

    @PostMapping("/getDowDutyLog")
    @ApiOperation(value = "本单位批量下载值班日志", notes = "单个下载传 id   批量导出传 companyIds")
    public void getDownloadDutyLogsss(@RequestBody TSysDutyLogParam param) throws Exception {
        UserInfo loginUser = ContextUtils.getLoginUser();
        List<String> companyIds = param.getCompanyIds();
        QueryWrapper<TSysDutyLog> queryWrapper = new QueryWrapper<>();
        String dutyOrgId = param.getId();
        Template template = configuration.getTemplate("dowdutylog.ftl");
        //模板位置
        if (StringHelper.isNotEmpty(dutyOrgId)) {
            queryWrapper.eq(TSysDutyLog.ID, dutyOrgId);
            TSysDutyLog one = tSysDutyLogService.getOne(queryWrapper);
            one.setIssueApply("\n办理情况："+one.getIssueApply()+";遗留问题："+one.getPreHandoverIssue());
            Map<String, Object> oneMap = objectToMap(one);
            //作业活动
            String jobId = one.getJobId();
            String[] split = jobId.split(",");
            QueryWrapper<TSysTaskWork> wrapper = new QueryWrapper<>();
            wrapper.in(TSysTaskWork.ID, split);
            //获取作业活动
            List<TSysTaskWork> tSysTaskWorks = tSysTaskWorkService.export(wrapper);
            oneMap.put("taskWorkList", tSysTaskWorks);
            //ToDo 获取文件流转为base64格式

            toDo64(one, oneMap);
            //作业活动
            String onefileName = one.getCompanyName() + one.getDutyDate() + one.getSubmitter() + "值班工作日志.doc";
            ServletOutputStream servletOutputStream = exportWordFreemarker(onefileName);
            Writer bufferedWriter = new BufferedWriter(new OutputStreamWriter(servletOutputStream, "utf-8"));
            template.process(oneMap, bufferedWriter);
        } else {
            if (companyIds != null && companyIds.size()>0) {
                queryWrapper.in(TSysDutyLog.COMPANY_ID, companyIds);
            } else {
                String orgId = loginUser.getOrgId();
                queryWrapper.eq(TSysDutyLog.COMPANY_ID, orgId);
            }
            List<TSysDutyLog> list = tSysDutyLogService.list(queryWrapper);
            try {
                ZipArchiveOutputStream zos = ZipExport();
                for (TSysDutyLog tSysDutyLog : list) {
                    ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
                    Template template1 = configuration.getTemplate("dowdutylog.ftl");
                    Map<String, Object> tSysDutyLogMap = objectToMap(tSysDutyLog);
                    //导出文件名称
                    String fileName = tSysDutyLog.getCompanyName() + tSysDutyLog.getDutyDate() + tSysDutyLog.getSubmitter() + "值班工作日志.doc";
                    tSysDutyLog.setIssueApply("\n办理情况："+tSysDutyLog.getIssueApply()+";遗留问题："+tSysDutyLog.getPreHandoverIssue());
                    // 导出模板
                    //作业活动
                    String jobId = tSysDutyLog.getJobId();
                    String[] split = jobId.split(",");
                    QueryWrapper<TSysTaskWork> wrapper = new QueryWrapper<>();
                    wrapper.in(TSysTaskWork.ID, split);
                    //作业活动
                    List<TSysTaskWork> tSysTaskWorks = tSysTaskWorkService.export(wrapper);
                    tSysDutyLogMap.put("taskWorkList", tSysTaskWorks);
                    //ToDo 获取文件流转为base64格式
                    toDo64(tSysDutyLog, tSysDutyLogMap);
                    Writer bufferedWriter = new BufferedWriter(new OutputStreamWriter(arrayOutputStream, "utf-8"));
                    template.process(tSysDutyLogMap, bufferedWriter);
                    ArchiveEntry entry = new ZipArchiveEntry(fileName);
                    zos.putArchiveEntry(entry);
                    zos.write(arrayOutputStream.toByteArray());
                    zos.closeArchiveEntry();
                    arrayOutputStream.close();
                }
                zos.close();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void toDo64(TSysDutyLog one, Map<String, Object> oneMap) {
        if (StringUtils.isNotBlank(one.getSuccessionSign())) {
            String successionSign = one.getSuccessionSign().substring(addr.length(), one.getSuccessionSign().length());

            oneMap.put("imginfoOne", FileUtil.convertImageFromUrlToBase64(imgInport+successionSign));
        }else {
            oneMap.put("imginfoOne","/9j/4AAQSkZJRgABAQAAkACQAAD/4QCARXhpZgAATU0AKgAAAAgABAEaAAUAAAABAAAA" +
                    "PgEbAAUAAAABAAAARgEoAAMAAAABAAIAAIdpAAQAAAABAAAATgAAAAAAAACQAAAAAQAAAJAAAAABAAOgAQADAAA" +
                    "AAf//AACgAgAEAAAAAQAAAU6gAwAEAAAAAQAAAJgAAAAA/+0AOFBob3Rvc2hvcCAzLjAAOEJJTQQEAAAAAAAAOEJJ" +
                    "TQQlAAAAAAAQ1B2M2Y8AsgTpgAmY7PhCfv/iEAhJQ0NfUFJPRklMRQABAQAAD/hhcHBsAhAAAG1udHJSR0IgWFlaIA" +
                    "fnAAQAAQAJAAwAJmFjc3BBUFBMAAAAAEFQUEwAAAAAAAAAAAAAAAAAAAAAAAD21gABAAAAANMtYXBwbAAAAAAAAAAAAAAA" +
                    "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEmRlc2MAAAFcAAAAYmRzY20AAAHAAAAEnGNwcnQAAAZcAAA" +
                    "AI3d0cHQAAAaAAAAAFHJYWVoAAAaUAAAAFGdYWVoAAAaoAAAAFGJYWVoAAAa8AAAAFHJUUkMAAAbQAAAIDGFhcmcAAA7cAA" +
                    "AAIHZjZ3QAAA78AAAAMG5kaW4AAA8sAAAAPmNoYWQAAA9sAAAALG1tb2QAAA+YAAAAKHZjZ3AAAA/AAAAAOGJUUkMAAAbQAA" +
                    "AIDGdUUkMAAAbQAAAIDGFhYmcAAA7cAAAAIGFhZ2cAAA7cAAAAIGRlc2MAAAAAAAAACERpc3BsYXkAAAAAAAAAAAAAAAAAAA" +
                    "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABtbHVjAAA" +
                    "AAAAAACYAAAAMaHJIUgAAABQAAAHYa29LUgAAAAwAAAHsbmJOTwAAABIAAAH4aWQAAAAAABIAAAIKaHVIVQAAABQAAAIcY3NDW" +
                    "gAAABYAAAIwZGFESwAAABwAAAJGbmxOTAAAABYAAAJiZmlGSQAAABAAAAJ4aXRJVAAAABgAAAKIZXNFUwAAABYAAAKgcm9STwA" +
                    "AABIAAAK2ZnJDQQAAABYAAALIYXIAAAAAABQAAALedWtVQQAAABwAAALyaGVJTAAAABYAAAMOemhUVwAAAAoAAAMkdmlWTgAAAA" +
                    "4AAAMuc2tTSwAAABYAAAM8emhDTgAAAAoAAAMkcnVSVQAAACQAAANSZW5HQgAAABQAAAN2ZnJGUgAAABYAAAOKbXMAAAAAABIAA" +
                    "AOgaGlJTgAAABIAAAOydGhUSAAAAAwAAAPEY2FFUwAAABgAAAPQZW5BVQAAABQAAAN2ZXNYTAAAABIAAAK2ZGVERQAAABAAAAPoZW5VUwAAABIAAAP4cHRCUgAAABgAAAQKcGxQTAAAABIAAAQiZWxHUgAAACIAAAQ0c3ZTRQAAABAAAARWdHJUUgAAABQAAARmcHRQVAAAABYAAAR6amFKUAAAAAwAAASQAEwAQwBEACAAdQAgAGIAbwBqAGnO7LfsACAATABDAEQARgBhAHIAZwBlAC0ATABDAEQATABDAEQAIABXAGEAcgBuAGEAUwB6AO0AbgBlAHMAIABMAEMARABCAGEAcgBlAHYAbgD9ACAATABDAEQATABDAEQALQBmAGEAcgB2AGUAcwBrAOYAcgBtAEsAbABlAHUAcgBlAG4ALQBMAEMARABWAOQAcgBpAC0ATABDAEQATABDAEQAIABhACAAYwBvAGwAbwByAGkATABDAEQAIABhACAAYwBvAGwAbwByAEwAQwBEACAAYwBvAGwAbwByAEEAQwBMACAAYwBvAHUAbABlAHUAciAPAEwAQwBEACAGR" +
                    "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");
        }
        if (StringUtils.isNotBlank(one.getHandoverSign())) {
            String handoverSign = one.getHandoverSign().substring(addr.length(), one.getHandoverSign().length());
            oneMap.put("imginfoTwo", FileUtil.convertImageFromUrlToBase64(imgInport+handoverSign));

        }else {
            oneMap.put("imginfoTwo","/9j/4AAQSkZJRgABAQAAkACQAAD/4QCARXhpZgAATU0AKgAAAAgABAEaAAUAAAABAAAA" +
                    "PgEbAAUAAAABAAAARgEoAAMAAAABAAIAAIdpAAQAAAABAAAATgAAAAAAAACQAAAAAQAAAJAAAAABAAOgAQADAAA" +
                    "AAf//AACgAgAEAAAAAQAAAU6gAwAEAAAAAQAAAJgAAAAA/+0AOFBob3Rvc2hvcCAzLjAAOEJJTQQEAAAAAAAAOEJJ" +
                    "TQQlAAAAAAAQ1B2M2Y8AsgTpgAmY7PhCfv/iEAhJQ0NfUFJPRklMRQABAQAAD/hhcHBsAhAAAG1udHJSR0IgWFlaIA" +
                    "fnAAQAAQAJAAwAJmFjc3BBUFBMAAAAAEFQUEwAAAAAAAAAAAAAAAAAAAAAAAD21gABAAAAANMtYXBwbAAAAAAAAAAAAAAA" +
                    "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEmRlc2MAAAFcAAAAYmRzY20AAAHAAAAEnGNwcnQAAAZcAAA" +
                    "AI3d0cHQAAAaAAAAAFHJYWVoAAAaUAAAAFGdYWVoAAAaoAAAAFGJYWVoAAAa8AAAAFHJUUkMAAAbQAAAIDGFhcmcAAA7cAA" +
                    "AAIHZjZ3QAAA78AAAAMG5kaW4AAA8sAAAAPmNoYWQAAA9sAAAALG1tb2QAAA+YAAAAKHZjZ3AAAA/AAAAAOGJUUkMAAAbQAA" +
                    "AIDGdUUkMAAAbQAAAIDGFhYmcAAA7cAAAAIGFhZ2cAAA7cAAAAIGRlc2MAAAAAAAAACERpc3BsYXkAAAAAAAAAAAAAAAAAAA" +
                    "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABtbHVjAAA" +
                    "AAAAAACYAAAAMaHJIUgAAABQAAAHYa29LUgAAAAwAAAHsbmJOTwAAABIAAAH4aWQAAAAAABIAAAIKaHVIVQAAABQAAAIcY3NDW" +
                    "gAAABYAAAIwZGFESwAAABwAAAJGbmxOTAAAABYAAAJiZmlGSQAAABAAAAJ4aXRJVAAAABgAAAKIZXNFUwAAABYAAAKgcm9STwA" +
                    "AABIAAAK2ZnJDQQAAABYAAALIYXIAAAAAABQAAALedWtVQQAAABwAAALyaGVJTAAAABYAAAMOemhUVwAAAAoAAAMkdmlWTgAAAA" +
                    "4AAAMuc2tTSwAAABYAAAM8emhDTgAAAAoAAAMkcnVSVQAAACQAAANSZW5HQgAAABQAAAN2ZnJGUgAAABYAAAOKbXMAAAAAABIAA" +
                    "AOgaGlJTgAAABIAAAOydGhUSAAAAAwAAAPEY2FFUwAAABgAAAPQZW5BVQAAABQAAAN2ZXNYTAAAABIAAAK2ZGVERQAAABAAAAPoZW5VUwAAABIAAAP4cHRCUgAAABgAAAQKcGxQTAAAABIAAAQiZWxHUgAAACIAAAQ0c3ZTRQAAABAAAARWdHJUUgAAABQAAARmcHRQVAAAABYAAAR6amFKUAAAAAwAAASQAEwAQwBEACAAdQAgAGIAbwBqAGnO7LfsACAATABDAEQARgBhAHIAZwBlAC0ATABDAEQATABDAEQAIABXAGEAcgBuAGEAUwB6AO0AbgBlAHMAIABMAEMARABCAGEAcgBlAHYAbgD9ACAATABDAEQATABDAEQALQBmAGEAcgB2AGUAcwBrAOYAcgBtAEsAbABlAHUAcgBlAG4ALQBMAEMARABWAOQAcgBpAC0ATABDAEQATABDAEQAIABhACAAYwBvAGwAbwByAGkATABDAEQAIABhACAAYwBvAGwAbwByAEwAQwBEACAAYwBvAGwAbwByAEEAQwBMACAAYwBvAHUAbABlAHUAciAPAEwAQwBEACAGR" +
                    "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");
        }
    }

    @SneakyThrows
    @ApiOperation(value = "试卷导出 试卷管理——安全教育培训 ", notes = "Get TTrainPaper By Id")
    @PostMapping("/export")
    public void export(@RequestBody TTrainPaperParam param){
        Long page = 1L;
        Long limit = 9999L;
        Page<TTrainPaper> resultPage = new Page<>(page, limit);
        QueryWrapper<TTrainPaper> queryWrapper = this.createQuery(param);
        String orgId = ContextUtils.getLoginUser().getOrgId();

        List<SysOrg> list = sysOrgService.list(new QueryWrapper<SysOrg>().select("org_id")
                .eq("parent_id", orgId).like("parent_ids", orgId).eq("status", "0").eq("is_dept", "0"));
        List<String> collect = list.stream().map(SysOrg::getOrgId).collect(Collectors.toList());
        collect.add(orgId);
        collect.add("32cdbb3a278944f1a83ca40dbcc93c0a");
        queryWrapper.in(collect.size()>0,"org_id",collect);
        Page<TTrainPaper> resultList = tTrainPaperService.page(resultPage, queryWrapper);
        List <String>ids=new ArrayList<>();
        if (!CollectionUtils.isEmpty(resultList.getRecords())) {
            ids= resultList.getRecords().stream().map(TTrainPaper::getId).collect(Collectors.toList());
        }else {
            return;
        }
        ZipArchiveOutputStream zos = ZipExport();
        for (String id : ids) {
            ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
            //freemarker的模板对象，获取模板
            Template template = configuration.getTemplate("TrainPaperExport.ftl");
            BaseResponse<ReturnTrainPaper> detail = tTrainPaperService.detail(id);
            ReturnTrainPaper data = detail.getData();
            if (CollectionUtils.isEmpty(data.getTestQuestionsContent())) {
                data.setTestQuestionsContent(new ArrayList<>());
            }
//            if (CollectionUtils.isEmpty(data.get())) {
//                data.setTestQuestionsContent(new ArrayList<>());
//            }
            Map<String, Object> map = new HashMap<>();
            map.put("paper", data);
            String fileName = data.getTestPaperName()+".doc";
            Writer bufferedWriter = new BufferedWriter(new OutputStreamWriter(arrayOutputStream, "utf-8"));
            template.process(map, bufferedWriter);
            ArchiveEntry entry = new ZipArchiveEntry(fileName);
            zos.putArchiveEntry(entry);
            zos.write(arrayOutputStream.toByteArray());
            zos.closeArchiveEntry();
            arrayOutputStream.close();
        }
        zos.close();
    }

    @ApiOperation(value = "导入试题模板下载 试卷管理——安全教育培训 ", notes = "Get TTrainPaper By Id")
    @GetMapping("/paperTemplateDownload")
    public void paperTemplateDownload(String id) throws Exception {

        TTrainQuestionBank service = tTrainQuestionBankService.getById(id);
        //  题库名称
        String questionBankName = service.getQuestionBankName();

        String url = path + "/ureport/excel?_u=file:TestQuestionTemplate.ureport.xml&id=" + id;
        Map<String, String> map = new HashMap<>();
        List<Map<String, String>> mapList = new ArrayList<>();
        map.put("path", url);
        map.put("name", "试题模板");
        String name = questionBankName+".xlsx";
        mapList.add(map);
        FileUtil.ExcelUrlToFile(mapList, request, response, name);
        //freemarker的模板对象，获取模板
//        Template template = configuration.getTemplate("paperTemplateDownload.ftl");
//        BaseResponse<ReturnTrainPaperTemplate> detail = detailDownload(id);
//        ReturnTrainPaperTemplate data = detail.getData();
//        Map<String, Object> map = new HashMap<>();
//        map.put("paper", data);
////        template.process(map, new FileWriter("d:/list.xlsx"));
//        TTrainQuestionBank service = tTrainQuestionBankService.getById(id);
//        String questionBankName = service.getQuestionBankName();
//        String fileName = questionBankName+".xlsx";
//        ServletOutputStream servletOutputStream = exportWordFreemarker(fileName);
//        Writer bufferedWriter = new BufferedWriter(new OutputStreamWriter(servletOutputStream, "utf-8"));
//        template.process(map, bufferedWriter);
    }

    public List<TestQuestionsContentTemplate> getExcelContent(String dsName, String datasetName, Map<String, Object> parameters) {
        List<TestQuestionsContentTemplate> templates = new ArrayList<>();
        String id = parameters.get("id").toString();
        BaseResponse<ReturnTrainPaperTemplate> detail = null;
        try {
            detail = detailDownload(id);
        } catch (Exception e) {
            e.printStackTrace();
        }
        ReturnTrainPaperTemplate data = detail.getData();
        List<TestQuestionsContentTemplate> testQuestionsContentTemplate = data.getTestQuestionsContentTemplate();
        if (ObjectHelper.isEmpty(testQuestionsContentTemplate)) {
            return templates;
        }
        for (TestQuestionsContentTemplate contentTemplate : testQuestionsContentTemplate) {
            TestQuestionsContentTemplate template = BeanHelper.beanToBean(contentTemplate, TestQuestionsContentTemplate.class);
            for (OptionsTemplate optionsTemplate : contentTemplate.getOptionsTemplate()) {
                switch (optionsTemplate.getOptions()){
                    case "A":
                        template.setA(optionsTemplate.getOptionText());
                        break;
                    case "B":
                        template.setB(optionsTemplate.getOptionText());
                        break;
                    case "C":
                        template.setC(optionsTemplate.getOptionText());
                        break;
                    case "D":
                        template.setD(optionsTemplate.getOptionText());
                        break;
                }
            }
            templates.add(template);
        }
        return templates;
    }

    public BaseResponse<ReturnTrainPaperTemplate> detailDownload(String id) throws Exception {
        BaseResponse<ReturnTrainPaperTemplate> baseResponse = new BaseResponse<>();
        if (StringHelper.isNotEmpty(id)) {
            QueryWrapper<TTrainTestQuestions> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq(TTrainTestQuestions.QUESTION_BANK_ID, id);
            //试卷包含的所有试题
            List<TTrainTestQuestions> trainTestQuestionsList = tTrainTestQuestionsService.list(queryWrapper);
            // 返回试卷详情
            ReturnTrainPaperTemplate returnTrainPaper = new ReturnTrainPaperTemplate();
            // 存储所有的题目
            List<TestQuestionsContentTemplate> testQuestionsContents = new ArrayList<>();
            int num = 0;
            for (TTrainTestQuestions tTrainTestQuestions : trainTestQuestionsList) {
                String testQuestionsType = tTrainTestQuestions.getTestQuestionsType();
                //试题id
                String questionsId = tTrainTestQuestions.getId();
                num++;
                String isCorrect = "";
                if ("SELECT".equals(testQuestionsType) || "MORE_SELECT".equals(testQuestionsType)) {
                    // 每一个题目
                    TestQuestionsContentTemplate testQuestionsContent = BeanHelper.beanToBean(tTrainTestQuestions, TestQuestionsContentTemplate.class);
                    QueryWrapper<TTrainExamChoice> wrapper = new QueryWrapper<>();
                    wrapper.eq(TTrainExamChoice.TEST_QUESTIONS_ID, questionsId);
                    // 当前题目包含的所有选项
                    List<TTrainExamChoice> list1 = tTrainExamChoiceService.list(wrapper);
                    // 按照选项排序
                    list1 = list1.stream().sorted(Comparator.comparing(TTrainExamChoice::getOptions))
                            .collect(Collectors.toList());
                    List<OptionsTemplate> optionsList = new ArrayList<>();
                    for (TTrainExamChoice tTrainExamChoice : list1) {
                        OptionsTemplate options = BeanHelper.beanToBean(tTrainExamChoice, OptionsTemplate.class);
                        if ("1".equals(options.getIsCorrect())) {
                            isCorrect += options.getOptions() + "、";
                        }
                        String optionsTest = options.getOptionText();
                        options.setOptionText(optionsTest);
                        optionsList.add(options);
                    }
                    String testQuestionsContent1 =  testQuestionsContent.getTestQuestionsContent();
                    testQuestionsContent.setTestQuestionsContent(testQuestionsContent1);
                    testQuestionsContent.setOptionsTemplate(optionsList);
                    String score = "";
                    if ("SELECT".equals(testQuestionsType)) {
                        score = "单选题";
                    }
                    if ("MORE_SELECT".equals(testQuestionsType)) {
                        score = "多选题";
                    }
                    testQuestionsContent.setScore(score);
                    testQuestionsContent.setIsCorrect(isCorrect);
                    testQuestionsContents.add(testQuestionsContent);
                }
                if ("JUDGE".equals(testQuestionsType)) {
                    // 每一个题目
                    TestQuestionsContentTemplate testQuestionsContent = BeanHelper.beanToBean(tTrainTestQuestions, TestQuestionsContentTemplate.class);
                    QueryWrapper<TTrainExamJudgment> wrapper = new QueryWrapper<>();
                    wrapper.eq(TTrainExamJudgment.TEST_QUESTIONS_ID, questionsId);
                    // 当前题目包含的所有选项
                    List<TTrainExamJudgment> list1 = tTrainExamJudgmentService.list(wrapper);
                    // 按照选项排序
                    list1 = list1.stream().sorted(Comparator.comparing(TTrainExamJudgment::getOptions))
                            .collect(Collectors.toList());
                    List<OptionsTemplate> optionsList = new ArrayList<>();
                    for (TTrainExamJudgment tTrainExamChoice : list1) {
                        OptionsTemplate options = BeanHelper.beanToBean(tTrainExamChoice, OptionsTemplate.class);
                        if ("1".equals(options.getIsCorrect())) {
                            isCorrect = options.getOptions();
                        }
                        String optionsTest = options.getOptionText();
                        options.setOptionText(optionsTest);
                        optionsList.add(options);
                    }
                    String testQuestionsContent1 =  testQuestionsContent.getTestQuestionsContent();
                    testQuestionsContent.setTestQuestionsContent(testQuestionsContent1);
                    testQuestionsContent.setOptionsTemplate(optionsList);
                    String score = "";
                    if ("JUDGE".equals(testQuestionsType)) {
                        score = "判断题";
                    }
                    testQuestionsContent.setScore(score);
                    testQuestionsContent.setIsCorrect(isCorrect);
                    testQuestionsContents.add(testQuestionsContent);
                }
                returnTrainPaper.setTestQuestionsContentTemplate(testQuestionsContents);
            }
            baseResponse.setData(returnTrainPaper);
        } else {
            throw new BusinessException("请求参数不正确");
        }
        return baseResponse;
    }

    /**
     * 导出freemarker
     *
     * @param fileName
     * @return
     * @throws Exception
     */
    private ServletOutputStream exportWordFreemarker(String fileName) throws Exception {
        response.reset();
        response.setHeader("Content-Type", "application/octet-stream");
        response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        ServletOutputStream outputStream = response.getOutputStream();
        return outputStream;
    }

    /**
     * 对象转为map
     *
     * @param obj
     * @return
     * @throws IllegalAccessException
     */
    public static Map<String, Object> objectToMap(Object obj) throws IllegalAccessException {
        Map<String, Object> map = new HashMap<>();
        Class<?> clazz = obj.getClass();
        for (Field field : clazz.getDeclaredFields()) {
            field.setAccessible(true);
            String fieldName = field.getName();
            Object value = field.get(obj);
            map.put(fieldName, value);
        }
        return map;
    }

    /**
     * zip 打包导出
     *
     * @return
     */
    public ZipArchiveOutputStream ZipExport() throws Exception {
        String outputFileName = "文件" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + ".zip";
        response.reset();
        response.setHeader("Content-Type", "application/octet-stream");
        response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(outputFileName, "UTF-8"));
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        ZipArchiveOutputStream zos = new ZipArchiveOutputStream(response.getOutputStream());//压缩文件输出流
        zos.setUseZip64(Zip64Mode.AsNeeded);
        return zos;
    }
    /**
     * 列表查询条件及查询参数
     */
    private QueryWrapper<TTrainPaper> createQuery(TTrainPaperParam queryParam) {
        QueryWrapper<TTrainPaper> queryWrapper = new QueryWrapper<>();
        String orgId = ContextUtils.getLoginUser().getOrgId();
//        queryWrapper.eq(TTrainPaper.TEST_PAPER_STATUS, "1").or();
//        queryWrapper.eq(TTrainPaper.ORG_ID, orgId);
        queryWrapper.and(new Consumer<QueryWrapper<TTrainPaper>>() {
            @Override
            public void accept(QueryWrapper<TTrainPaper> tTrainPaperQueryWrapper) {
                tTrainPaperQueryWrapper.eq(TTrainPaper.TEST_PAPER_STATUS, "1").or().eq(TTrainPaper.ORG_ID, orgId);
            }
        });
        if (StringHelper.isNotEmpty(queryParam.getTestPaperStatus())) {
            queryWrapper.eq(TTrainPaper.TEST_PAPER_STATUS, queryParam.getTestPaperStatus());
        }
        if (StringHelper.isNotEmpty(queryParam.getTestPaperName())) {
            queryWrapper.like(TTrainPaper.TEST_PAPER_NAME, queryParam.getTestPaperName());
        }
        if (StringHelper.isNotEmpty(queryParam.getGroupPaperWay())) {
            queryWrapper.like(TTrainPaper.GROUP_PAPER_WAY, queryParam.getGroupPaperWay());
        }
        if (StringHelper.isNotEmpty(queryParam.getStatus())) {
            queryWrapper.eq(TTrainPaper.STATUS, queryParam.getStatus());
        } else {
            queryWrapper.ne(TTrainPaper.STATUS, BizConstants.STATUS_DELETE);
        }
        if (StringHelper.isNotEmpty(queryParam.getOrderBy())) {
            if (StringHelper.isNotEmpty(queryParam.getOrderType())
                    && BizConstants.ASC.equals(queryParam.getOrderType())) {
                queryWrapper.orderByAsc(queryParam.getOrderBy());
            } else {
                queryWrapper.orderByDesc(queryParam.getOrderBy());
            }
        } else {
            queryWrapper.orderByDesc(TTrainPaper.UPDATE_DATE);
        }
        return queryWrapper;
    }
}
