package com.testor.module.safe.service;


import com.testor.module.safe.model.domain.TSafeHazardStandard;
import com.testor.module.safe.model.dto.TSafeHazardStandardEditDTO;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperService;
import org.springframework.web.multipart.MultipartFile;

/**
 * 隐患巡检排查标准Service接口
 *
 * @author testor-framework
 * @date 2022-07-27 14:48:45
 */
public interface TSafeHazardStandardService extends SuperService<TSafeHazardStandard> {
    /**
     * 添加隐患巡检标准
     *
     * @param addRequest 添加对象
     * @return
     */
    BaseResponse<TSafeHazardStandard> addEntity(TSafeHazardStandardEditDTO addRequest);

    /**
     * 修改隐患巡检标准
     *
     * @param addRequest 添加对象
     * @return
     */
    BaseResponse<TSafeHazardStandard> updateEntity(TSafeHazardStandardEditDTO addRequest);


    /**
     * 修改隐患巡检标准状态
     *
     * @param addRequest 添加对象
     * @return
     */
    BaseResponse<String> updateProcessStatusEntity(TSafeHazardStandardEditDTO addRequest);

    /**
     * 标准导入
     *
     * @param file
     * @return
     */
    BaseResponse<String> addReportByExcel(MultipartFile file);
}
