package com.testor.module.safe.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.testor.biz.sys.org.model.domain.SysOrg;
import com.testor.biz.sys.org.service.SysOrgService;
import com.testor.common.constant.StatusEnum;
import com.testor.module.duty.util.PoiExcelUtils;
import com.testor.module.safe.dao.TSafeHazardStandardDao;
import com.testor.module.safe.model.domain.TSafeHazardOption;
import com.testor.module.safe.model.domain.TSafeHazardStandard;
import com.testor.module.safe.model.dto.TSafeHazardOptionEditDTO;
import com.testor.module.safe.model.dto.TSafeHazardStandardEditDTO;
import com.testor.module.safe.model.vo.TSafeHazardOptionVO;
import com.testor.module.safe.service.TSafeHazardOptionService;
import com.testor.module.safe.service.TSafeHazardStandardService;
import com.testor.module.sys.model.domian.NewSysOrg;
import com.testor.module.sys.service.NewSysOrgService;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.constants.enumeration.BaseStatusEnum;
import com.tongtech.tfw.backend.common.context.ContextUtils;
import com.tongtech.tfw.backend.common.models.exceptions.ApiException;
import com.tongtech.tfw.backend.common.models.response.ResponseInfo;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import com.tongtech.tfw.workflow.apis.definition.controller.ProcessDefinitionController;
import com.tongtech.tfw.workflow.apis.definition.model.dto.ProcessDefStartParam;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.io.InputStream;
import java.util.*;

/**
 * 隐患巡检排查标准Service业务层处理
 *
 * @author testor-framework
 * @date 2022-07-27 14:48:45
 */
@Service
public class TSafeHazardStandardServiceImpl extends SuperServiceImpl<TSafeHazardStandardDao, TSafeHazardStandard> implements TSafeHazardStandardService {
    @Autowired(required = false)
    private TSafeHazardStandardDao tSafeHazardStandardDao;

    @Autowired
    private TSafeHazardOptionService tSafeHazardOptionService;

    @Autowired
    private SysOrgService sysOrgService;

    @Autowired
    private NewSysOrgService newSysOrgService;


    @Transactional(rollbackFor = Exception.class)
    @Override
    public BaseResponse<TSafeHazardStandard> addEntity(TSafeHazardStandardEditDTO addRequest) {
        BaseResponse<TSafeHazardStandard> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(addRequest)) {
            String id = IdHelper.getId32bit();

            // 同一个机构下标准名称是唯一
            BaseResponse<TSafeHazardStandard> judgeStandardIsExist = getSafeHazardStandardBaseResponse(addRequest, baseResponse, 0);
            if (judgeStandardIsExist.getCode() != BaseStatusEnum.SUCCESS.code()) return judgeStandardIsExist;


            // 实际细则添加列表
            List<TSafeHazardOption> tSafeHazardOptionList = new ArrayList<>();

            List<TSafeHazardOptionEditDTO> levelOptionEditOneList = addRequest.getTSafeHazardOptionEditDTOList();
            for (TSafeHazardOptionEditDTO levelOptionEditOne : levelOptionEditOneList) {
                // 一级添加
                TSafeHazardOption levelOptionOne = BeanHelper.beanToBean(levelOptionEditOne, TSafeHazardOption.class);
                String levelOptionOneId = IdHelper.getId32bit();
                levelOptionOne.setParentId(id);
                levelOptionOne.setId(levelOptionOneId);
                levelOptionOne.setCheckType("1");
                tSafeHazardOptionList.add(levelOptionOne);

                List<TSafeHazardOptionEditDTO> levelOptionEditTowList = levelOptionEditOne.getTSafeHazardOptionEditDTOList();
                for (TSafeHazardOptionEditDTO levelOptionEditTow : levelOptionEditTowList) {
                    // 二级添加
                    TSafeHazardOption levelOptionTow = BeanHelper.beanToBean(levelOptionEditTow, TSafeHazardOption.class);
                    String levelOptionTowId = IdHelper.getId32bit();
                    levelOptionTow.setParentId(levelOptionOneId);
                    levelOptionTow.setId(levelOptionTowId);
                    levelOptionTow.setCheckType("2");
                    tSafeHazardOptionList.add(levelOptionTow);
                }
            }
            TSafeHazardStandard data = BeanHelper.beanToBean(addRequest, TSafeHazardStandard.class);
            data.setId(id);
            boolean saveStandard = save(data);
            if (saveStandard) {
                boolean saveOption = tSafeHazardOptionService.saveBatch(tSafeHazardOptionList);
                if (saveOption) {
                    TSafeHazardStandard newEntity = new TSafeHazardStandard();
                    newEntity.setId(id);
                    baseResponse.setData(newEntity);
                    return baseResponse;
                }
                throw new ApiException(new ResponseInfo(BaseStatusEnum.UN_DATA.code(), "隐患巡检排查标准添加失败"));
            }
        }
        return baseResponse;
    }

    /**
     * @param addRequest
     * @param baseResponse
     * @param type         0-新增，1-修改
     * @return
     */
    private BaseResponse<TSafeHazardStandard> getSafeHazardStandardBaseResponse(TSafeHazardStandardEditDTO addRequest, BaseResponse<TSafeHazardStandard> baseResponse, int type) {
        QueryWrapper<TSafeHazardStandard> standardQueryWrapper = new QueryWrapper<>();
        String standardName = addRequest.getStandardName();
        String orgId = addRequest.getOrgId();
        if (StringUtils.isEmpty(standardName) && StringUtils.isEmpty(orgId)) {
            String id = addRequest.getId();
            TSafeHazardStandard tSafeHazardStandard = getById(id);
            if (ObjectHelper.isNotEmpty(tSafeHazardStandard)) {
                baseResponse.setData(tSafeHazardStandard);
                return baseResponse;
            }
        }

        if (type == 0) {
            // 新增
            standardQueryWrapper.eq("standard_name", standardName);
            standardQueryWrapper.eq("org_id", orgId);
            standardQueryWrapper.eq("status", StatusEnum.USE.getCode());
            TSafeHazardStandard tSafeHazardStandard = getOne(standardQueryWrapper);
            if (ObjectHelper.isNotEmpty(tSafeHazardStandard)) {
                baseResponse.setCode(BaseStatusEnum.UN_DATA.code());
                baseResponse.setMsg("标准名称：" + tSafeHazardStandard.getStandardName() + "已存在");
                return baseResponse;
            } else {
                baseResponse.setData(tSafeHazardStandard);
                return baseResponse;
            }
        } else {
            standardQueryWrapper.eq("standard_name", standardName);
            standardQueryWrapper.eq("org_id", orgId);
            standardQueryWrapper.eq("status", StatusEnum.USE.getCode());
            TSafeHazardStandard tSafeHazardStandard = getOne(standardQueryWrapper);
            String id = addRequest.getId();
            if (ObjectHelper.isNotEmpty(tSafeHazardStandard)) {
                if (StringHelper.isEmpty(id)) {
                    baseResponse.setCode(BaseStatusEnum.UN_DATA.code());
                    baseResponse.setMsg("标准名称：" + tSafeHazardStandard.getStandardName() + "已存在");
                    return baseResponse;
                }
                if (!id.equals(tSafeHazardStandard.getId())) {
                    baseResponse.setCode(BaseStatusEnum.UN_DATA.code());
                    baseResponse.setMsg("标准名称：" + tSafeHazardStandard.getStandardName() + "已存在");
                    return baseResponse;
                }
            }
            tSafeHazardStandard = getById(id);
            if (ObjectHelper.isNotEmpty(tSafeHazardStandard)) {
                baseResponse.setData(tSafeHazardStandard);
                return baseResponse;
            } else {
                baseResponse.setCode(BaseStatusEnum.UN_DATA.code());
                baseResponse.setMsg("标准名称：" + tSafeHazardStandard.getStandardName() + "已存在");
                return baseResponse;
            }
        }
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public BaseResponse<TSafeHazardStandard> updateEntity(TSafeHazardStandardEditDTO addRequest) {
        BaseResponse<TSafeHazardStandard> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(addRequest)) {

            // 实际细则添加列表
            List<TSafeHazardOption> tSafeHazardOptionList = new ArrayList<>();

            // 同一个机构下标准名称是唯一
            BaseResponse<TSafeHazardStandard> judgeStandardIsExist = getSafeHazardStandardBaseResponse(addRequest, baseResponse, 1);
            if (judgeStandardIsExist.getCode() != BaseStatusEnum.SUCCESS.code()) return judgeStandardIsExist;

            TSafeHazardStandard judgeStandardIsExistData = judgeStandardIsExist.getData();

            List<TSafeHazardOption> tSafeHazardOptionDelList = new ArrayList<>();
            List<TSafeHazardOptionVO> byParentIdList = tSafeHazardOptionService.getCheckContent(judgeStandardIsExistData.getId());
            for (TSafeHazardOptionVO levelOptionVo : byParentIdList) {
                // 一级添加

                TSafeHazardOption tSafeHazardOptionDelOne = new TSafeHazardOption();
                tSafeHazardOptionDelOne.setId(levelOptionVo.getId());
                tSafeHazardOptionDelOne.setStatus(StatusEnum.DELETE.getCode());
                tSafeHazardOptionDelList.add(tSafeHazardOptionDelOne);


                List<TSafeHazardOptionVO> levelOptionEditTowList = levelOptionVo.getTSafeHazardOptionEditDTOList();
                for (TSafeHazardOptionVO levelOptionEditTow : levelOptionEditTowList) {
                    // 二级添加
                    TSafeHazardOption tSafeHazardOptionDelTow = new TSafeHazardOption();
                    tSafeHazardOptionDelTow.setId(levelOptionEditTow.getId());
                    tSafeHazardOptionDelTow.setStatus(StatusEnum.DELETE.getCode());
                    tSafeHazardOptionDelList.add(tSafeHazardOptionDelTow);
                }
            }

            List<TSafeHazardOptionEditDTO> levelOptionEditOneList = addRequest.getTSafeHazardOptionEditDTOList();

            if (null != levelOptionEditOneList && levelOptionEditOneList.size() > 0) {
                for (TSafeHazardOptionEditDTO levelOptionEditOne : levelOptionEditOneList) {
                    // 一级添加
                    TSafeHazardOption levelOptionOne = BeanHelper.beanToBean(levelOptionEditOne, TSafeHazardOption.class);
                    levelOptionOne.setParentId(addRequest.getId());
                    levelOptionOne.setCheckType("1");
                    String levelOptionOneId = IdHelper.getId32bit();
                    levelOptionOne.setId(levelOptionOneId);
                    tSafeHazardOptionList.add(levelOptionOne);

                    List<TSafeHazardOptionEditDTO> levelOptionEditTowList = levelOptionEditOne.getTSafeHazardOptionEditDTOList();
                    for (TSafeHazardOptionEditDTO levelOptionEditTow : levelOptionEditTowList) {
                        // 二级添加
                        TSafeHazardOption levelOptionTow = BeanHelper.beanToBean(levelOptionEditTow, TSafeHazardOption.class);
                        levelOptionTow.setParentId(levelOptionOneId);
                        levelOptionTow.setCheckType("2");
                        String levelOptionTowId = IdHelper.getId32bit();
                        levelOptionTow.setId(levelOptionTowId);
                        tSafeHazardOptionList.add(levelOptionTow);
                    }
                }
                TSafeHazardStandard data = BeanHelper.beanToBean(addRequest, TSafeHazardStandard.class);
                boolean updateStandard = updateById(data);
                if (updateStandard) {


                    boolean updateBatchById = tSafeHazardOptionService.updateBatchById(tSafeHazardOptionDelList);
                    if (updateBatchById) {
                        boolean saveOption = tSafeHazardOptionService.saveBatch(tSafeHazardOptionList);
                        if (saveOption) {
                            TSafeHazardStandard newEntity = new TSafeHazardStandard();
                            newEntity.setId(data.getId());
                            baseResponse.setData(newEntity);
                            return baseResponse;
                        }
                    }
                    throw new ApiException(new ResponseInfo(BaseStatusEnum.UN_DATA.code(), "隐患巡检排查标准添加失败"));
                }
            } else {
                TSafeHazardStandard data = BeanHelper.beanToBean(addRequest, TSafeHazardStandard.class);
                boolean updateStandard = updateById(data);
                if (updateStandard) {
                    TSafeHazardStandard newEntity = new TSafeHazardStandard();
                    newEntity.setId(data.getId());
                    baseResponse.setData(newEntity);
                    return baseResponse;
                }
            }
        }
        return baseResponse;
    }

    @Override
    public BaseResponse<String> updateProcessStatusEntity(TSafeHazardStandardEditDTO addRequest) {
        BaseResponse<String> baseResponse = new BaseResponse<>();
        String id = addRequest.getId();
        TSafeHazardStandard tSafeHazardStandard = getById(id);
        if (ObjectHelper.isEmpty(tSafeHazardStandard)) {
            baseResponse.setCode(BaseStatusEnum.UN_DATA.code());
            baseResponse.setMsg("当前标准不存在");
            return baseResponse;
        }
        String status = tSafeHazardStandard.getStatus();
        if (!StatusEnum.USE.getCode().equals(status)) {
            baseResponse.setCode(BaseStatusEnum.UN_DATA.code());
            baseResponse.setMsg("当前标准状态异常");
            return baseResponse;
        }
        // 标准状态（0-禁用/1-现行/2-废止
        String processStatus = tSafeHazardStandard.getProcessStatus();

        /*if ("3".equals(processStatus)) {
            baseResponse.setCode(BaseStatusEnum.UN_DATA.code());
            baseResponse.setMsg("禁用状态下禁止修改");
            return baseResponse;
        }*/

        String addRequestProcessStatus = addRequest.getProcessStatus();
        if (addRequestProcessStatus.equals(processStatus)) {
            baseResponse.setCode(BaseStatusEnum.UN_DATA.code());
            baseResponse.setMsg("请勿重复操作");
            return baseResponse;
        }

        // 废止判断
        if ("6".equals(addRequestProcessStatus)) {
            // 判断是否有巡检计划使用
            if (isCheckPlan(id)) {
                baseResponse.setCode(BaseStatusEnum.UN_DATA.code());
                baseResponse.setMsg("排查计划正在使用，无法废止");
                return baseResponse;
            }
        }

        TSafeHazardStandard updateEntity = new TSafeHazardStandard();
        updateEntity.setId(id);
        updateEntity.setProcessStatus(addRequestProcessStatus);
        boolean update = updateById(updateEntity);
        if (!update) {
            baseResponse.setCode(BaseStatusEnum.UN_DATA.code());
            baseResponse.setMsg("修改状态失败");
        }
        return baseResponse;

    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public BaseResponse<String> addReportByExcel(MultipartFile file) {
        BaseResponse<String> baseResponse = new BaseResponse<>();

        InputStream inputStream = null;
        try {
            inputStream = file.getInputStream();
            //获得第一个表单
        } catch (IOException e) {
            e.printStackTrace();
        }
        Workbook workbook = PoiExcelUtils.readFile(inputStream, Objects.requireNonNull(file.getOriginalFilename()));
        Sheet sheet = workbook.getSheetAt(0);
        List<Map<Integer, Object>> list = PoiExcelUtils.getBody(sheet, 7, 5);
        if (list.size() == 0) {
            throw new ApiException(new ResponseInfo(BaseStatusEnum.UN_DATA.code(), " 请勿上传空模板"));
        }
        Map<String, TSafeHazardStandardEditDTO> storage = new HashMap<>();
        //检查项
        Set<String> checkTheItem = new HashSet<>();
        Map<String, String> orgNameMap = new HashMap<>();
        for (Map<Integer, Object> integerObjectMap : list) {
            String orgName = integerObjectMap.get(0).toString();

            String orgId = orgNameMap.get(orgName);

            if (StringHelper.isEmpty(orgId)) {
                QueryWrapper<SysOrg> orgQueryWrapper = new QueryWrapper<>();
                orgQueryWrapper.eq("org_name", orgName);
                orgQueryWrapper.eq("is_dept", "0");
                SysOrg sysOrgServiceOne = sysOrgService.getOne(orgQueryWrapper);
                if (ObjectHelper.isEmpty(sysOrgServiceOne)) {
                    throw new ApiException(new ResponseInfo(BaseStatusEnum.UN_DATA.code(), orgName + " 该机构不存在，无法添加"));
                }
                orgId = sysOrgServiceOne.getOrgId();
                orgNameMap.put(orgName, orgId);
            }
            if (!orgId.equals(ContextUtils.getLoginUser().getOrgId())) {
                throw new ApiException(new ResponseInfo(BaseStatusEnum.UN_DATA.code(), " 您不属于[" + orgName + "],无法添加"));
            }
            String standarType = integerObjectMap.get(2).toString();
            String standarName = integerObjectMap.get(3).toString();
            String checkName = integerObjectMap.get(4).toString();
            String checkContent = integerObjectMap.get(5).toString();
            String checkMethod = integerObjectMap.get(6).toString();

            String judgeString = orgName + standarName;
            //检验标准是否存储
            TSafeHazardStandardEditDTO check = storage.get(judgeString);
            if (check == null) {
                TSafeHazardStandardEditDTO tSafeHazardStandardEditDTO = new TSafeHazardStandardEditDTO();
                List<TSafeHazardOptionEditDTO> tSafeHazardOptionEditDTOs = new ArrayList<>();

                TSafeHazardOptionEditDTO tSafeHazardOptionEditDTO = new TSafeHazardOptionEditDTO();
                tSafeHazardStandardEditDTO.setOrgId(orgId);
                tSafeHazardStandardEditDTO.setProcessStatus("3");
                tSafeHazardStandardEditDTO.setOrgName(orgName);
                tSafeHazardStandardEditDTO.setStandardType(standarType);

                //设置检查项名称
                tSafeHazardOptionEditDTO.setCheckName(checkName);
                //设置检查项的细则
                List<TSafeHazardOptionEditDTO> details = new ArrayList<>();
                TSafeHazardOptionEditDTO detail = new TSafeHazardOptionEditDTO();
                detail.setCheckContent(checkContent);
                detail.setCheckMethod(checkMethod);
                //添加
                details.add(detail);
                //存储细则
                tSafeHazardOptionEditDTO.setTSafeHazardOptionEditDTOList(details);
                //添加检查项及其细则
                tSafeHazardOptionEditDTOs.add(tSafeHazardOptionEditDTO);
                checkTheItem.add(judgeString + checkName);
                //检查项细则
                tSafeHazardStandardEditDTO.setTSafeHazardOptionEditDTOList(tSafeHazardOptionEditDTOs);

                tSafeHazardStandardEditDTO.setStandardName(standarName);
                tSafeHazardStandardEditDTO.setStandardChild(standarType);
                storage.put(judgeString, tSafeHazardStandardEditDTO);
            } else {
                List<TSafeHazardOptionEditDTO> tSafeHazardOptionEditDTOList = check.getTSafeHazardOptionEditDTOList();
                List<TSafeHazardOptionEditDTO> elementsToAdd = new ArrayList<>();

                for (TSafeHazardOptionEditDTO tSafeHazardOptionEditDTO : tSafeHazardOptionEditDTOList) {
                    if (checkTheItem.contains(judgeString + checkName)) {
                        if (tSafeHazardOptionEditDTO.getCheckName().equals(checkName)) {
                            // 设置检查项的细则
                            TSafeHazardOptionEditDTO detail = new TSafeHazardOptionEditDTO();
                            detail.setCheckContent(checkContent);
                            detail.setCheckMethod(checkMethod);
                            tSafeHazardOptionEditDTO.getTSafeHazardOptionEditDTOList().add(detail);
                        }
                    } else {
                        TSafeHazardOptionEditDTO tSafeHazardOptionEditDTO1 = new TSafeHazardOptionEditDTO();
                        // 设置检查项名称
                        tSafeHazardOptionEditDTO1.setCheckName(checkName);
                        // 设置检查项的细则
                        List<TSafeHazardOptionEditDTO> details = new ArrayList<>();
                        TSafeHazardOptionEditDTO detail = new TSafeHazardOptionEditDTO();
                        detail.setCheckContent(checkContent);
                        detail.setCheckMethod(checkMethod);
                        // 添加
                        details.add(detail);
                        // 存储细则
                        tSafeHazardOptionEditDTO1.setTSafeHazardOptionEditDTOList(details);
                        // 添加到新元素列表中
                        elementsToAdd.add(tSafeHazardOptionEditDTO1);
                        checkTheItem.add(judgeString + checkName);
                    }
                }
                // 将新元素添加到原始列表中
                tSafeHazardOptionEditDTOList.addAll(elementsToAdd);

            }
        }

        Set<String> set = storage.keySet();
        for (String s : set) {
            TSafeHazardStandardEditDTO tSafeHazardStandardEditDTO = storage.get(s);
            BaseResponse<TSafeHazardStandard> tSafeHazardStandardBaseResponse = addEntityByExcel(tSafeHazardStandardEditDTO);
            if (tSafeHazardStandardBaseResponse.getCode() != BaseStatusEnum.SUCCESS.code()) {
                baseResponse.setCode(tSafeHazardStandardBaseResponse.getCode());
                baseResponse.setMsg(tSafeHazardStandardBaseResponse.getMsg());
                return baseResponse;
            }
        }
        return baseResponse;
    }


    @Autowired
    private ProcessDefinitionController processDefinitionController;

    @Transactional(rollbackFor = Exception.class)
    public BaseResponse<TSafeHazardStandard> addEntityByExcel(TSafeHazardStandardEditDTO addRequest) {
        BaseResponse<TSafeHazardStandard> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(addRequest)) {
            String orgId = addRequest.getOrgId();
            NewSysOrg sysOrg = newSysOrgService.getById(orgId);
            String id = IdHelper.getId32bit();

            // 同一个机构下标准名称是唯一
            BaseResponse<TSafeHazardStandard> judgeStandardIsExist = getSafeHazardStandardBaseResponse(addRequest, baseResponse, 0);
            if (judgeStandardIsExist.getCode() != BaseStatusEnum.SUCCESS.code()) return judgeStandardIsExist;


            // 实际细则添加列表
            List<TSafeHazardOption> tSafeHazardOptionList = new ArrayList<>();

            List<TSafeHazardOptionEditDTO> levelOptionEditOneList = addRequest.getTSafeHazardOptionEditDTOList();
            for (TSafeHazardOptionEditDTO levelOptionEditOne : levelOptionEditOneList) {
                // 一级添加
                TSafeHazardOption levelOptionOne = BeanHelper.beanToBean(levelOptionEditOne, TSafeHazardOption.class);
                String levelOptionOneId = IdHelper.getId32bit();
                levelOptionOne.setParentId(id);
                levelOptionOne.setId(levelOptionOneId);
                levelOptionOne.setCheckType("1");
                tSafeHazardOptionList.add(levelOptionOne);

                List<TSafeHazardOptionEditDTO> levelOptionEditTowList = levelOptionEditOne.getTSafeHazardOptionEditDTOList();
                for (TSafeHazardOptionEditDTO levelOptionEditTow : levelOptionEditTowList) {
                    // 二级添加
                    TSafeHazardOption levelOptionTow = BeanHelper.beanToBean(levelOptionEditTow, TSafeHazardOption.class);
                    String levelOptionTowId = IdHelper.getId32bit();
                    levelOptionTow.setParentId(levelOptionOneId);
                    levelOptionTow.setId(levelOptionTowId);
                    levelOptionTow.setCheckType("2");
                    tSafeHazardOptionList.add(levelOptionTow);
                }
            }
            TSafeHazardStandard data = BeanHelper.beanToBean(addRequest, TSafeHazardStandard.class);
            data.setId(id);
            boolean saveStandard = save(data);
            if (saveStandard) {
                boolean saveOption = tSafeHazardOptionService.saveBatch(tSafeHazardOptionList);
                //如果层级不为总部
                if (saveOption && !sysOrg.getTreeLevel().toString().equals("1")) {
                    TSafeHazardStandard newEntity = new TSafeHazardStandard();
                    newEntity.setId(id);
                    baseResponse.setData(newEntity);
                    ProcessDefStartParam processDefStartParam = new ProcessDefStartParam("checkStandard");
                    Map<String, Object> variables = new HashMap<>();
                    variables.put("status", 0);
                    String processStatus = "3";
                    variables.put("processStatus", processStatus);
                    variables.put("treeLevel", sysOrg.getTreeLevel().toString());
                    processDefStartParam.setBizKey(id);
                    processDefStartParam.setVariables(variables);
                    String result = processDefinitionController.startProcessIns(processDefStartParam).getData().getResult();
                    TSafeHazardStandardEditDTO tSafeHazardStandardEditDTO = new TSafeHazardStandardEditDTO();
                    tSafeHazardStandardEditDTO.setId(id);
                    tSafeHazardStandardEditDTO.setProcessId(result);
                    updateEntity(tSafeHazardStandardEditDTO);
                    return baseResponse;
                }else if (sysOrg.getTreeLevel().toString().equals("1")){
                    TSafeHazardStandard tSafeHazardStandard = new TSafeHazardStandard();
                    tSafeHazardStandard.setId(id);
                    tSafeHazardStandard.setProcessStatus("5");
                    tSafeHazardStandardDao.updateById(tSafeHazardStandard);
                }
            }
        }
        return baseResponse;
    }


    /**
     * 判断是否有巡检计划使用
     *
     * @return ture-废止不能通过/false-废止可通过
     */
    private boolean isCheckPlan(String standardId) {
        List<String> checkPlan = tSafeHazardStandardDao.isCheckPlan(standardId);
        if (null != checkPlan && checkPlan.size() > 0) {
            return true;
        }
        return false;
    }
}
