package com.testor.module.safeCheck.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.testor.module.safeCheck.dao.TSafeCheckPersonArrangeDao;
import com.testor.module.safeCheck.model.domain.TSafeCheckPersonArrange;
import com.testor.module.safeCheck.service.TSafeCheckPersonArrangeService;
import org.springframework.stereotype.Service;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Collections;
import java.util.List;

/**
 * 安全检查计划人员安排(具体人员)Service业务层处理
 * 
 * @author testor-framework
 * @date 2024-09-05 02:25:41
 */
@Service
public class TSafeCheckPersonArrangeServiceImpl extends SuperServiceImpl<TSafeCheckPersonArrangeDao, TSafeCheckPersonArrange> implements TSafeCheckPersonArrangeService
{
    @Autowired(required = false)
    private TSafeCheckPersonArrangeDao tSafeCheckPersonArrangeDao;

    @Override
    public List<TSafeCheckPersonArrange> getListByPlanId(String id) {
        return this.list(new LambdaQueryWrapper<TSafeCheckPersonArrange>().eq(TSafeCheckPersonArrange::getPlanId, id));
    }

    @Override
    public List<TSafeCheckPersonArrange> getListByCheckPersonId(String CheckPersonId) {
        return this.list(new LambdaQueryWrapper<TSafeCheckPersonArrange>().eq(TSafeCheckPersonArrange::getCheckPersonId, CheckPersonId));
    }
}
