/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.monitor.core.instrument;

import com.tongweb.commons.monitor.core.instrument.Measurement;
import com.tongweb.commons.monitor.core.instrument.Meter;
import com.tongweb.commons.monitor.core.instrument.MeterRegistry;
import com.tongweb.commons.monitor.core.instrument.Statistic;
import com.tongweb.commons.monitor.core.instrument.Tag;
import com.tongweb.commons.monitor.core.instrument.Tags;
import java.util.Collections;
import java.util.function.ToDoubleFunction;

public interface FunctionCounter
extends Meter {
    public static <T> Builder<T> builder(String name, T obj, ToDoubleFunction<T> f) {
        return new Builder(name, obj, f);
    }

    public double count();

    @Override
    default public Iterable<Measurement> measure() {
        return Collections.singletonList(new Measurement(this::count, Statistic.COUNT));
    }

    public static class Builder<T> {
        private final String name;
        private final ToDoubleFunction<T> f;
        private Tags tags = Tags.empty();
        private final T obj;
        private String description;
        private String baseUnit;

        private Builder(String name, T obj, ToDoubleFunction<T> f) {
            this.name = name;
            this.obj = obj;
            this.f = f;
        }

        public Builder<T> tags(String ... tags) {
            return this.tags(Tags.of(tags));
        }

        public Builder<T> tags(Iterable<Tag> tags) {
            this.tags = this.tags.and(tags);
            return this;
        }

        public Builder<T> tag(String key, String value) {
            this.tags = this.tags.and(key, value);
            return this;
        }

        public Builder<T> description(String description) {
            this.description = description;
            return this;
        }

        public Builder<T> baseUnit(String unit) {
            this.baseUnit = unit;
            return this;
        }

        public FunctionCounter register(MeterRegistry registry) {
            return registry.more().counter(new Meter.Id(this.name, this.tags, this.baseUnit, this.description, Meter.Type.COUNTER), this.obj, this.f);
        }
    }
}

