/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.monitor.core.instrument.distribution;

import com.tongweb.commons.monitor.core.instrument.distribution.PercentileHistogramBuckets;
import com.tongweb.commons.monitor.core.instrument.internal.Mergeable;
import java.time.Duration;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.stream.LongStream;

public class DistributionStatisticConfig
implements Mergeable<DistributionStatisticConfig> {
    public static final DistributionStatisticConfig DEFAULT = DistributionStatisticConfig.builder().percentilesHistogram(false).percentilePrecision(1).minimumExpectedValue(1.0).maximumExpectedValue(Double.POSITIVE_INFINITY).expiry(Duration.ofMinutes(2L)).bufferLength(3).build();
    public static final DistributionStatisticConfig NONE = DistributionStatisticConfig.builder().build();
    private Boolean percentileHistogram;
    private double[] percentiles;
    private Integer percentilePrecision;
    private double[] serviceLevelObjectives;
    private Double minimumExpectedValue;
    private Double maximumExpectedValue;
    private Duration expiry;
    private Integer bufferLength;

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public DistributionStatisticConfig merge(DistributionStatisticConfig parent) {
        return DistributionStatisticConfig.builder().percentilesHistogram(this.percentileHistogram == null ? parent.percentileHistogram : this.percentileHistogram).percentiles(this.percentiles == null ? parent.percentiles : this.percentiles).serviceLevelObjectives(this.serviceLevelObjectives == null ? parent.serviceLevelObjectives : this.serviceLevelObjectives).percentilePrecision(this.percentilePrecision == null ? parent.percentilePrecision : this.percentilePrecision).minimumExpectedValue(this.minimumExpectedValue == null ? parent.minimumExpectedValue : this.minimumExpectedValue).maximumExpectedValue(this.maximumExpectedValue == null ? parent.maximumExpectedValue : this.maximumExpectedValue).expiry(this.expiry == null ? parent.expiry : this.expiry).bufferLength(this.bufferLength == null ? parent.bufferLength : this.bufferLength).build();
    }

    public NavigableSet<Double> getHistogramBuckets(boolean supportsAggregablePercentiles) {
        TreeSet<Double> buckets = new TreeSet<Double>();
        if (this.percentileHistogram != null && this.percentileHistogram.booleanValue() && supportsAggregablePercentiles) {
            buckets.addAll(PercentileHistogramBuckets.buckets(this));
            buckets.add(this.minimumExpectedValue);
            buckets.add(this.maximumExpectedValue);
        }
        if (this.serviceLevelObjectives != null) {
            for (double slaBoundary : this.serviceLevelObjectives) {
                buckets.add(slaBoundary);
            }
        }
        return buckets;
    }

    public Boolean isPercentileHistogram() {
        return this.percentileHistogram;
    }

    public double[] getPercentiles() {
        return this.percentiles;
    }

    public Integer getPercentilePrecision() {
        return this.percentilePrecision;
    }

    @Deprecated
    public Double getMinimumExpectedValue() {
        return this.getMinimumExpectedValueAsDouble();
    }

    public Double getMinimumExpectedValueAsDouble() {
        return this.minimumExpectedValue;
    }

    @Deprecated
    public Double getMaximumExpectedValue() {
        return this.getMaximumExpectedValueAsDouble();
    }

    public Double getMaximumExpectedValueAsDouble() {
        return this.maximumExpectedValue;
    }

    public Duration getExpiry() {
        return this.expiry;
    }

    public Integer getBufferLength() {
        return this.bufferLength;
    }

    @Deprecated
    public double[] getSlaBoundaries() {
        return this.getServiceLevelObjectiveBoundaries();
    }

    public double[] getServiceLevelObjectiveBoundaries() {
        return this.serviceLevelObjectives;
    }

    public boolean isPublishingPercentiles() {
        return this.percentiles != null && this.percentiles.length > 0;
    }

    public boolean isPublishingHistogram() {
        return this.percentileHistogram != null && this.percentileHistogram != false || this.serviceLevelObjectives != null && this.serviceLevelObjectives.length > 0;
    }

    static /* synthetic */ double[] access$102(DistributionStatisticConfig x0, double[] x1) {
        x0.percentiles = x1;
        return x1;
    }

    static /* synthetic */ double[] access$302(DistributionStatisticConfig x0, double[] x1) {
        x0.serviceLevelObjectives = x1;
        return x1;
    }

    public static class Builder {
        private final DistributionStatisticConfig config = new DistributionStatisticConfig();

        public Builder percentilesHistogram(Boolean enabled) {
            this.config.percentileHistogram = enabled;
            return this;
        }

        public Builder percentiles(double ... percentiles) {
            DistributionStatisticConfig.access$102(this.config, percentiles);
            return this;
        }

        public Builder percentilePrecision(Integer digitsOfPrecision) {
            this.config.percentilePrecision = digitsOfPrecision;
            return this;
        }

        public Builder serviceLevelObjectives(double ... slos) {
            DistributionStatisticConfig.access$302(this.config, slos);
            return this;
        }

        @Deprecated
        public Builder sla(double ... sla) {
            return this.serviceLevelObjectives(sla);
        }

        @Deprecated
        public Builder sla(long ... sla) {
            return sla == null ? this : this.serviceLevelObjectives(LongStream.of(sla).asDoubleStream().toArray());
        }

        @Deprecated
        public Builder minimumExpectedValue(Long min) {
            return min == null ? this : this.minimumExpectedValue((double)min);
        }

        public Builder minimumExpectedValue(Double min) {
            this.config.minimumExpectedValue = min;
            return this;
        }

        @Deprecated
        public Builder maximumExpectedValue(Long max) {
            return max == null ? this : this.maximumExpectedValue((double)max);
        }

        public Builder maximumExpectedValue(Double max) {
            this.config.maximumExpectedValue = max;
            return this;
        }

        public Builder expiry(Duration expiry) {
            this.config.expiry = expiry;
            return this;
        }

        public Builder bufferLength(Integer bufferLength) {
            this.config.bufferLength = bufferLength;
            return this;
        }

        public DistributionStatisticConfig build() {
            return this.config;
        }
    }
}

