/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.dataview.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.exceptions.ApiException;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.datetime.DatetimeHelper;
import com.tongtech.tfw.dataview.DataviewEnumCode;
import com.tongtech.tfw.dataview.model.domain.TDataview;
import com.tongtech.tfw.dataview.model.domain.TDataviewConfig;
import com.tongtech.tfw.dataview.model.dto.DataViewDTO;
import com.tongtech.tfw.dataview.model.dto.DataViewFileDTO;
import com.tongtech.tfw.dataview.model.dto.TDataviewDelParam;
import com.tongtech.tfw.dataview.model.dto.TDataviewParam;
import com.tongtech.tfw.dataview.service.TDataviewConfigService;
import com.tongtech.tfw.dataview.service.TDataviewService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/dataview/dataview"})
@Api(value="TDataview", tags={"DataView \u53ef\u89c6\u5316"})
public class TDataviewController
extends SuperController {
    private static final Logger log = LoggerFactory.getLogger(TDataviewController.class);
    @Autowired
    private TDataviewService tDataviewService;
    @Autowired
    private TDataviewConfigService tDataviewConfigService;
    @Value(value="${dataview.file}")
    private String fileRootPath;

    @GetMapping(value={"/detail"})
    @ApiOperation(value="\u8be6\u60c5", notes="\u8be6\u60c5,get dataView")
    public BaseResponse<DataViewDTO> detail(String id) {
        BaseResponse baseResponse = new BaseResponse();
        TDataview dataView = (TDataview)((Object)this.tDataviewService.getById((Serializable)((Object)id)));
        TDataviewConfig dataViewConfig = (TDataviewConfig)((Object)this.tDataviewConfigService.getOne((Wrapper)new QueryWrapper().lambda().eq(TDataviewConfig::getDataViewId, (Object)id)));
        DataViewDTO dto = new DataViewDTO();
        dto.setDataView(dataView);
        dto.setConfig(dataViewConfig);
        baseResponse.setData((Object)dto);
        return baseResponse;
    }

    @ApiOperation(value="\u65b0\u589e \u53ef\u89c6\u5316", notes="\u65b0\u589e \u53ef\u89c6\u5316 Add TDataview")
    @PostMapping(value={"/add"})
    public BaseResponse<TDataview> addEntity(@RequestBody DataViewDTO addRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)addRequest)) {
            TDataview data = this.tDataviewService.saveComb(addRequest, this.getUserId());
            TDataview newEntity = new TDataview();
            newEntity.setId(data.getId());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u4fee\u6539 \u53ef\u89c6\u5316 ", notes="\u4fee\u6539 \u53ef\u89c6\u5316 Update TDataview By Id")
    @PutMapping(value={"/update"})
    public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody DataViewDTO updateRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)updateRequest)) {
            boolean result = this.tDataviewService.updateComb(updateRequest, this.getUserId());
            baseResponse.setData((Object)BizGeneralResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u5220\u9664 \u53ef\u89c6\u5316 ", notes="\u5220\u9664 \u53ef\u89c6\u5316 delete TDataview By Id")
    @PutMapping(value={"/delete"})
    public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TDataviewDelParam deleteRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)deleteRequest) && StringHelper.isNotEmpty((CharSequence)deleteRequest.getId())) {
            TDataview data = new TDataview();
            data.setId(deleteRequest.getId());
            data.setStatus("1");
            boolean result = this.tDataviewService.updateById((Object)data);
            baseResponse.setData((Object)BizGeneralResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u53ef\u89c6\u5316", notes="\u6279\u91cf\u5220\u9664\u53ef\u89c6\u5316 delete TDataview by batch Id")
    @PutMapping(value={"/batch_delete"})
    public BaseResponse<BizGeneralResponse> deleteEntityBatch(@RequestBody TDataviewDelParam deleteRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)deleteRequest) && !deleteRequest.getIds().isEmpty()) {
            ArrayList<TDataview> tDataviewList = new ArrayList<TDataview>();
            for (String id : deleteRequest.getIds()) {
                TDataview data = new TDataview();
                data.setId(id);
                data.setStatus("1");
                tDataviewList.add(data);
            }
            boolean result = this.tDataviewService.updateBatchById(tDataviewList);
            baseResponse.setData((Object)BizGeneralResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6 \u53ef\u89c6\u5316 \u5206\u9875\u5217\u8868", notes="\u83b7\u53d6 \u53ef\u89c6\u5316 \u5206\u9875\u5217\u8868 List TDataview with page")
    @GetMapping(value={"/list"})
    public BaseResponse<BaseResponseList<TDataview>> listEntity(TDataviewParam param) {
        BaseResponse baseResponse = new BaseResponse();
        Long page = StringHelper.isEmpty((CharSequence)param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit = StringHelper.isEmpty((CharSequence)param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
        Page resultPage = new Page(page.longValue(), limit.longValue());
        QueryWrapper<TDataview> queryWrapper = this.createQuery(param);
        Page resultList = (Page)this.tDataviewService.page((IPage)resultPage, (Wrapper)queryWrapper);
        BaseResponseList baseResponseList = new BaseResponseList();
        baseResponseList.setData(resultList.getRecords());
        baseResponseList.setTotal(resultList.getTotal());
        baseResponse.setData((Object)baseResponseList);
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6 \u53ef\u89c6\u5316 \u5217\u8868", notes="\u83b7\u53d6 \u53ef\u89c6\u5316 \u5217\u8868 List TDataview all")
    @GetMapping(value={"/datas"})
    public BaseResponse<BaseResponseList<TDataview>> listAllEntity(TDataviewParam param) {
        BaseResponse baseResponse = new BaseResponse();
        QueryWrapper<TDataview> queryWrapper = this.createQuery(param);
        List resultList = this.tDataviewService.list((Wrapper)queryWrapper);
        BaseResponseList baseResponseList = new BaseResponseList();
        baseResponseList.setData(resultList);
        baseResponseList.setTotal((long)resultList.size());
        baseResponse.setData((Object)baseResponseList);
        return baseResponse;
    }

    @PostMapping(value={"/copy"})
    @ApiOperation(value="\u590d\u5236 \u53ef\u89c6\u5316", notes="\u590d\u5236 DataView \u4f20\u5165id")
    public BaseResponse<BizGeneralResponse> copy(String id) {
        BaseResponse baseResponse = new BaseResponse();
        String result = this.tDataviewService.copyDataView(id, this.getUserId());
        baseResponse.setData((Object)BizGeneralResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        return baseResponse;
    }

    @ApiOperation(value="\u4e0a\u4f20\u6587\u4ef6", notes="\u4e0a\u4f20\u6587\u4ef6 Upload File")
    @PostMapping(value={"/put-file"})
    public BaseResponse<DataViewFileDTO> upload(@RequestParam MultipartFile file) {
        BaseResponse baseResponse = new BaseResponse();
        if (file.isEmpty()) {
            throw new ApiException(DataviewEnumCode.NOT_FOUND.transform());
        }
        String fileName = file.getOriginalFilename();
        int beginIndex = fileName.indexOf(".") + 1;
        String ext = StringHelper.substring((String)fileName, (int)beginIndex, (int)fileName.length());
        String filePath = DatetimeHelper.getDateTime8Length();
        String saveName = IdHelper.getId32bit();
        try {
            File path = new File(this.fileRootPath + filePath);
            if (!path.exists()) {
                path.mkdirs();
            }
            File dest = new File(new File(this.fileRootPath + filePath).getAbsolutePath() + File.separator + saveName + "." + ext);
            FileCopyUtils.copy((byte[])file.getBytes(), (File)dest);
            log.info("\u4fdd\u5b58\u6210\u529f\uff1aFileId\uff1a" + saveName + ", ext: " + ext + ", path:" + filePath + ", name:" + fileName + ", user: " + this.getUserId());
        }
        catch (IOException e) {
            log.error(e.toString(), (Throwable)e);
            throw new ApiException(DataviewEnumCode.IO_FAILD.transform());
        }
        DataViewFileDTO newEntity = DataViewFileDTO.builder().link(filePath + File.separator + saveName).build();
        baseResponse.setData((Object)newEntity);
        return baseResponse;
    }

    private QueryWrapper<TDataview> createQuery(TDataviewParam queryParam) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getStatus())) {
            queryWrapper.eq((Object)"status", (Object)queryParam.getStatus());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getTitle())) {
            queryWrapper.like((Object)"title", (Object)queryParam.getTitle());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getBackgroundUrl())) {
            queryWrapper.eq((Object)"background_url", (Object)queryParam.getBackgroundUrl());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getCategory())) {
            queryWrapper.eq((Object)"category", (Object)queryParam.getCategory());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getPassword())) {
            queryWrapper.eq((Object)"password", (Object)queryParam.getPassword());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getStatus())) {
            queryWrapper.eq((Object)"status", (Object)queryParam.getStatus());
        } else {
            queryWrapper.ne((Object)"status", (Object)"1");
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getOrderBy())) {
            if (StringHelper.isNotEmpty((CharSequence)queryParam.getOrderType()) && "asc".equals(queryParam.getOrderType())) {
                queryWrapper.orderByAsc((Object)queryParam.getOrderBy());
            } else {
                queryWrapper.orderByDesc((Object)queryParam.getOrderBy());
            }
        } else {
            queryWrapper.orderByDesc((Object)"update_date");
        }
        return queryWrapper;
    }
}

