//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by FernFlower decompiler)
//

package com.testor.config;

import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.tongtech.tfw.backend.common.jwt.JwtHelper;
import com.tongtech.tfw.backend.common.models.jwt.JwtInfos;
import com.tongtech.tfw.backend.common.request.RequestUtil;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import java.time.LocalDateTime;
import java.util.Date;

import org.apache.ibatis.reflection.MetaObject;
import org.springframework.stereotype.Component;

@Component
public class TfwMetaObjectHandler implements MetaObjectHandler {
    public TfwMetaObjectHandler() {
    }

    @Override
    public void insertFill(MetaObject metaObject) {
        String userId = null;
        if (ObjectHelper.isNotEmpty(RequestUtil.getRequest())) {
            String authorization = RequestUtil.getRequest().getHeader("Authorization");
            JwtInfos jwtInfos = JwtHelper.parseJwtAuth0(authorization, "Token Issuer");
            userId = jwtInfos.getUserId();
        }

        if (ObjectHelper.isEmpty(this.getFieldValByName("createBy", metaObject))) {
            this.setFieldValByName("createBy", userId, metaObject);
        }

        if (ObjectHelper.isEmpty(this.getFieldValByName("updateBy", metaObject))) {
            this.setFieldValByName("updateBy", userId, metaObject);
        }

        this.setFieldValByName("createDate", new Date(), metaObject);
        this.setFieldValByName("updateDate", new Date(), metaObject);
        if (ObjectHelper.isEmpty(this.getFieldValByName("status", metaObject))) {
            this.setFieldValByName("status", "0", metaObject);
        }

    }

    @Override
    public void updateFill(MetaObject metaObject) {
        String userId = null;
        if (ObjectHelper.isNotEmpty(RequestUtil.getRequest())) {
            String authorization = RequestUtil.getRequest().getHeader("Authorization");
            JwtInfos jwtInfos = JwtHelper.parseJwtAuth0(authorization, "Token Issuer");
            userId = jwtInfos.getUserId();
        }

        if (ObjectHelper.isEmpty(this.getFieldValByName("updateBy", metaObject))) {
            this.setFieldValByName("updateBy", userId, metaObject);
        }

        this.setFieldValByName("updateDate", new Date(), metaObject);
    }
}

