package com.testor.module.contractor.ledger.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.testor.module.contractor.ledger.dao.TContractorInfoDao;
import com.testor.module.contractor.ledger.model.domain.TContractorInfo;
import com.testor.module.contractor.ledger.model.dto.TContractorInfoDelParam;
import com.testor.module.contractor.ledger.model.dto.TContractorInfoParam;
import com.testor.module.contractor.ledger.service.TContractorInfoService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import org.springframework.stereotype.Service;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * 承包商信息Service业务层处理
 * 
 * @author testor-framework
 * @date 2024-11-22 13:41:30
 */
@Service
public class TContractorInfoServiceImpl extends SuperServiceImpl<TContractorInfoDao, TContractorInfo> implements TContractorInfoService
{
    @Autowired(required = false)
    private TContractorInfoDao tContractorInfoDao;

    @Override
    public TContractorInfo getInfoByNameAndCreditCode(String name, String creditCode) {
        return this.getOne(new LambdaQueryWrapper<TContractorInfo>().eq(TContractorInfo::getName, name).eq(TContractorInfo::getCreditCode, creditCode));
    }

    @Override
    public List<TContractorInfo> getInfoByName(String name) {
        return this.list(new LambdaQueryWrapper<TContractorInfo>().eq(TContractorInfo::getName, name));
    }

    @Override
    public boolean deleteEntity(String infoId) {
        TContractorInfo data= new TContractorInfo();
        data.setId(infoId);
        data.setStatus(BizConstants.STATUS_DELETE);
        return this.updateById(data);
    }

    @Override
    public List<TContractorInfo> selectAll(TContractorInfoParam param) {
        return this.baseMapper.selectAll(param);
    }

    @Override
    public String getName(String infoId) {
        // 处理每个ID
        List<String> names = new ArrayList<>();
        if (StringUtils.isNotBlank(infoId)) {
            // 分割多个ID（如果有）
            String[] ids = infoId.split(",");
            for (String id : ids) {
                TContractorInfo tContractorInfo = this.getById(id.trim());
                if (tContractorInfo != null) {
                    names.add(tContractorInfo.getName());
                }
            }

        }
        return String.join(",", names);
    }
}
