package com.testor.module.contractor.manage.controller;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import lombok.extern.slf4j.Slf4j;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RestController;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.exceptions.ApiException;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;

import com.testor.module.contractor.manage.model.domain.TContractorDailyPlanTools;
import com.testor.module.contractor.manage.model.dto.TContractorDailyPlanToolsParam;
import com.testor.module.contractor.manage.model.dto.TContractorDailyPlanToolsDelParam;
import com.testor.module.contractor.manage.service.TContractorDailyPlanToolsService;

/**
 * 日常管理计划-工器具台账关联Controller
 *
 * @author testor-framework
 * @date 2024-12-10 14:08:32
 */
@RestController
@RequestMapping("/manage/tools")
@Api(value = "TContractorDailyPlanTools", tags = "日常管理计划-工器具台账关联")
@Slf4j
public class TContractorDailyPlanToolsController extends SuperController
{
    @Autowired
    private TContractorDailyPlanToolsService tContractorDailyPlanToolsService;

    /* Generated Method*/
	@ApiOperation(value = "新增 日常管理计划-工器具台账关联", notes = "Add TContractorDailyPlanTools")
	@PostMapping(value = "/add")
	public BaseResponse<TContractorDailyPlanTools>addEntity(@RequestBody TContractorDailyPlanTools addRequest) {
		BaseResponse<TContractorDailyPlanTools> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(addRequest)){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
			String id = IdHelper.getId32bit();
            TContractorDailyPlanTools data=BeanHelper.beanToBean(addRequest,  TContractorDailyPlanTools.class);
			data.setId(id);
			boolean result= tContractorDailyPlanToolsService.save(data);
			if(result){
                TContractorDailyPlanTools newEntity = new TContractorDailyPlanTools();
				newEntity.setId(id);
				baseResponse.setData(newEntity);
			}
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 日常管理计划-工器具台账关联 ", notes = "Get TContractorDailyPlanTools By Id")
	@GetMapping(value = "/get")
	public BaseResponse<TContractorDailyPlanTools> getById(String id){
		BaseResponse<TContractorDailyPlanTools> baseResponse=new BaseResponse<>();
		if(StringHelper.isNotEmpty(id)){
			// TODO 按需求添加业务异常判断
            TContractorDailyPlanTools data= tContractorDailyPlanToolsService.getById(id);
			baseResponse.setData(data);
		}
		return baseResponse;
	}

	@ApiOperation(value = "修改 日常管理计划-工器具台账关联 ", notes = "Update TContractorDailyPlanTools By Id")
	@PutMapping(value = "/update")
	public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody TContractorDailyPlanTools updateRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(updateRequest)&&StringHelper.isNotEmpty(updateRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TContractorDailyPlanTools data=BeanHelper.beanToBean(updateRequest, TContractorDailyPlanTools.class);
			boolean result= tContractorDailyPlanToolsService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "删除 日常管理计划-工器具台账关联 ", notes = "delete TContractorDailyPlanTools By Id")
	@PutMapping(value = "/delete")
	public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TContractorDailyPlanToolsDelParam deleteRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(deleteRequest)&&StringHelper.isNotEmpty(deleteRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TContractorDailyPlanTools data= new TContractorDailyPlanTools();
			data.setId(deleteRequest.getId());
			data.setStatus(BizConstants.STATUS_DELETE);
			boolean result= tContractorDailyPlanToolsService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "批量删除日常管理计划-工器具台账关联", notes = "delete TContractorDailyPlanTools by batch Id")
	@PutMapping(value = "/batch_delete")
	public BaseResponse<BizGeneralResponse> deleteEntityBatch(
			@RequestBody TContractorDailyPlanToolsDelParam deleteRequest) {
		BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
		if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            /* 批量删除 */
			List<TContractorDailyPlanTools> tContractorDailyPlanToolsList = new ArrayList<>();
            for(String id: deleteRequest.getIds()){
                TContractorDailyPlanTools data= new TContractorDailyPlanTools();
				data.setId(id);
				data.setStatus(BizConstants.STATUS_DELETE);
                tContractorDailyPlanToolsList.add(data);
			}
			boolean result = tContractorDailyPlanToolsService.updateBatchById(tContractorDailyPlanToolsList);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 日常管理计划-工器具台账关联 分页列表", notes = "List TContractorDailyPlanTools with page")
	@GetMapping(value = "/list")
	public  BaseResponse<BaseResponseList<TContractorDailyPlanTools>>listEntity(TContractorDailyPlanToolsParam param){
		BaseResponse<BaseResponseList<TContractorDailyPlanTools>>baseResponse=new BaseResponse<>();
		Long page=
				StringHelper.isEmpty(param.getPage())?BizConstants.PAGE:Long.valueOf(param.getPage());
		Long limit=
				StringHelper.isEmpty(param.getLimit())?BizConstants.LIMIT:Long.valueOf(param.getLimit());
		Page<TContractorDailyPlanTools> resultPage=new Page<>(page,limit);
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<TContractorDailyPlanTools> queryWrapper=this.createQuery(param);
		Page<TContractorDailyPlanTools> resultList= tContractorDailyPlanToolsService.page(resultPage,queryWrapper);
		BaseResponseList<TContractorDailyPlanTools> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList.getRecords());
		baseResponseList.setTotal(resultList.getTotal());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

	@ApiOperation(value = "获取 日常管理计划-工器具台账关联 列表", notes = "List TContractorDailyPlanTools all")
	@GetMapping(value = "/datas")
	public  BaseResponse<BaseResponseList<TContractorDailyPlanTools>>listAllEntity(TContractorDailyPlanToolsParam param){
		BaseResponse<BaseResponseList<TContractorDailyPlanTools>>baseResponse=new BaseResponse<>();
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<TContractorDailyPlanTools> queryWrapper=this.createQuery(param);
		List<TContractorDailyPlanTools> resultList=tContractorDailyPlanToolsService.list(queryWrapper);
		BaseResponseList<TContractorDailyPlanTools> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList);
		baseResponseList.setTotal(resultList.size());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

    /* Private Methods */
	/**
     * 列表查询条件及查询参数
     */
	private QueryWrapper<TContractorDailyPlanTools> createQuery(TContractorDailyPlanToolsParam queryParam){
		QueryWrapper<TContractorDailyPlanTools> queryWrapper=new QueryWrapper<>();
		if(StringHelper.isNotEmpty(queryParam.getPlanId())){
			queryWrapper.eq(TContractorDailyPlanTools.PLAN_ID,queryParam.getPlanId());
		}
		if(StringHelper.isNotEmpty(queryParam.getToolsId())){
			queryWrapper.eq(TContractorDailyPlanTools.TOOLS_ID,queryParam.getToolsId());
		}
		if(StringHelper.isNotEmpty(queryParam.getBizId())){
			queryWrapper.eq(TContractorDailyPlanTools.BIZ_ID,queryParam.getBizId());
		}
		if(StringHelper.isNotEmpty(queryParam.getContractorId())){
			queryWrapper.eq(TContractorDailyPlanTools.CONTRACTOR_ID,queryParam.getContractorId());
		}
		if(StringHelper.isNotEmpty(queryParam.getProjId())){
			queryWrapper.eq(TContractorDailyPlanTools.PROJ_ID,queryParam.getProjId());
		}
		if (StringHelper.isNotEmpty(queryParam.getStatus())) {
			queryWrapper.eq(TContractorDailyPlanTools.STATUS, queryParam.getStatus());
		} else {
			queryWrapper.ne(TContractorDailyPlanTools.STATUS, BizConstants.STATUS_DELETE);
		}
		if (StringHelper.isNotEmpty(queryParam.getOrderBy())){
			if(StringHelper.isNotEmpty(queryParam.getOrderType())
					&&BizConstants.ASC.equals(queryParam.getOrderType())){
				queryWrapper.orderByAsc(queryParam.getOrderBy());
			}else{
				queryWrapper.orderByDesc(queryParam.getOrderBy());
			}
		}else{
			queryWrapper.orderByDesc(TContractorDailyPlanTools.UPDATE_DATE);
		}
		return queryWrapper;
	}
}
