package com.testor.module.contractor.manage.model.domain;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.testor.common.annotation.Translation;
import com.testor.common.constant.TransConstant;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import org.springframework.format.annotation.DateTimeFormat;


/**
 * 承包商考核评价对象 t_contractor_evaluate
 *
 * @author testor-framework
 * @date 2024-11-30 15:42:18
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_contractor_evaluate")
@ApiModel(value = "TContractorEvaluate对象", description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TContractorEvaluate extends SuperModel {
    private static final long serialVersionUID = 1L;
    /**
     * 主键id
     */
    @ApiModelProperty(value = "主键id")

    @TableId("id")
    private String id;
    /**
     * 承包商台账id
     */
    @ApiModelProperty(value = "承包商台账id")

    @TableField("contractor_id")
    private String contractorId;
    /**
     * 项目id
     */
    @ApiModelProperty(value = "项目id")

    @TableField("proj_id")
    private String projId;
    /**
     * 业务id(标识是一条基本信息产生的关系)
     */
    @ApiModelProperty(value = "业务id(标识是一条基本信息产生的关系)")

    @TableField("biz_id")
    private String bizId;
    /**
     * 流程实例ID
     */
    @ApiModelProperty(value = "流程实例ID")

    @TableField("process_id")
    private String processId;
    /**
     * 流程状态
     */
    @ApiModelProperty(value = "流程状态")

    @TableField("process_status")
    private String processStatus;
    /**
     * 评估表类型id（数据字典id）
     */
    @ApiModelProperty(value = "评估表类型id（数据字典id）")

    @TableField("evaluation_sheet_type_id")
    private String evaluationSheetTypeId;
    /**
     * 评估表类型
     */
    @ApiModelProperty(value = "评估表类型")
    @Translation(type = TransConstant.DICT_ID_TO_LABEL,mapper = "evaluationSheetTypeId")
    @TableField("evaluation_sheet_type")
    private String evaluationSheetType;
    /**
     * 评价主体（数据字典id）
     */
    @ApiModelProperty(value = "评价主体（数据字典id）")

    @TableField("evaluation_subject_id")
    private String evaluationSubjectId;
    /**
     * 评价主体
     */
    @ApiModelProperty(value = "评价主体")
    @Translation(type = TransConstant.DICT_ID_TO_LABEL,mapper = "evaluationSubjectId")
    @TableField("evaluation_subject")
    private String evaluationSubject;
    /**
     * 考核周期id（数据字典id）
     */
    @ApiModelProperty(value = "考核周期id（数据字典id）")

    @TableField("evaluation_cycle_id")
    private String evaluationCycleId;
    /**
     * 考核周期
     */
    @ApiModelProperty(value = "考核周期")
    @Translation(type = TransConstant.DICT_ID_TO_LABEL,mapper = "evaluationCycleId")
    @TableField("evaluation_cycle")
    private String evaluationCycle;
    /**
     * 是否涉及否决项，0无 1重复隐患 2安全事故
     */
    @ApiModelProperty(value = "是否涉及否决项，0无 1重复隐患 2安全事故")

    @TableField("if_veto")
    private String ifVeto;
    /**
     * 得分
     */
    @ApiModelProperty(value = "得分", example = "0")

    @TableField("score")
    private BigDecimal score;

    /**
     * 评价等级
     */
    @ApiModelProperty(value = "评价等级")
    @TableField("evaluate_level")
    private String evaluateLevel;

    /**
     * 驳回意见
     */
    @ApiModelProperty(value = "驳回意见")

    @TableField("reject_opinion")
    private String rejectOpinion;
    /**
     * 组织id
     */
    @ApiModelProperty(value = "组织id")

    @TableField("org_id")
    private String orgId;


    /**
     * 是否下一步，0否 1是
     */
    @ApiModelProperty(value ="是否下一步，0否 1是")
    @TableField("if_next")
    private String ifNext;

    @ApiModelProperty(value = "评价人")
    @TableField("evaluate_person")
    private String evaluatePerson;

    @ApiModelProperty(value = "评价时间")
    @TableField("evaluate_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date evaluateTime;

    public static final String ID = "id";
    public static final String CONTRACTOR_ID = "contractor_id";
    public static final String PROJ_ID = "proj_id";
    public static final String BIZ_ID = "biz_id";
    public static final String PROCESS_ID = "process_id";
    public static final String PROCESS_STATUS = "process_status";
    public static final String EVALUATION_SHEET_TYPE_ID = "evaluation_sheet_type_id";
    public static final String EVALUATION_SHEET_TYPE = "evaluation_sheet_type";
    public static final String EVALUATION_SUBJECT_ID = "evaluation_subject_id";
    public static final String EVALUATION_SUBJECT = "evaluation_subject";
    public static final String EVALUATION_CYCLE_ID = "evaluation_cycle_id";
    public static final String EVALUATION_CYCLE = "evaluation_cycle";
    public static final String IF_VETO = "if_veto";
    public static final String SCORE = "score";
    public static final String REJECT_OPINION = "reject_opinion";
    public static final String ORG_ID = "org_id";
    public static final String EVALUATE_LEVEL = "evaluate_level";
    public static final String IF_NEXT = "if_next";
    public static final String EVALUATE_PERSON = "evaluate_person";
    public static final String EVALUATE_TIME = "evaluate_time";

}
