package com.testor.module.contractor.manage.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.contractor.ledger.model.domain.TContractorPerson;
import com.testor.module.contractor.ledger.service.TContractorPersonService;
import com.testor.module.contractor.manage.dao.TContractorPreparationAnalysisDao;
import com.testor.module.contractor.manage.model.domain.TContractorPreparationAnalysis;
import com.testor.module.contractor.manage.model.dto.TContractorPreparationAnalysisParam;
import com.testor.module.contractor.manage.service.TContractorPreparationAnalysisService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import org.springframework.stereotype.Service;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 开工准备-风险分析和控制措施Service业务层处理
 * 
 * @author testor-framework
 * @date 2024-11-24 13:19:48
 */
@Service
public class TContractorPreparationAnalysisServiceImpl extends SuperServiceImpl<TContractorPreparationAnalysisDao, TContractorPreparationAnalysis> implements TContractorPreparationAnalysisService
{
    @Autowired(required = false)
    private TContractorPreparationAnalysisDao tContractorPreparationAnalysisDao;

    @Autowired
    private TContractorPersonService tContractorPersonService;

    @Override
    public Page<TContractorPreparationAnalysis> listEntity(TContractorPreparationAnalysisParam param) {
        Long page =
                StringHelper.isEmpty(param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit =
                StringHelper.isEmpty(param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
        Page<TContractorPreparationAnalysis> resultPage = new Page<>(page, limit);
        QueryWrapper<TContractorPreparationAnalysis> queryWrapper = this.createQuery(param);
        Page<TContractorPreparationAnalysis> resultList = this.page(resultPage, queryWrapper);
        for (TContractorPreparationAnalysis data : resultList.getRecords()) {
            String personId = data.getPersonId();
            if (StringHelper.isNotEmpty(personId)) {
                TContractorPerson person = tContractorPersonService.getById(personId);
                String personName = person == null ? "" : person.getName();
                data.setPersonName(personName);
            }
        }
        return resultList;
    }

    @Override
    public List<TContractorPreparationAnalysis> listAllEntity(TContractorPreparationAnalysisParam param) {
        QueryWrapper<TContractorPreparationAnalysis> queryWrapper = this.createQuery(param);
        List<TContractorPreparationAnalysis> resultList = this.list(queryWrapper);
        for (TContractorPreparationAnalysis data : resultList) {
            String personId = data.getPersonId();
            if (StringHelper.isNotEmpty(personId)) {
                TContractorPerson person = tContractorPersonService.getById(personId);
                String personName = person == null ? "" : person.getName();
                data.setPersonName(personName);
            }
        }
        return resultList;
    }

    /* Private Methods */

    /**
     * 列表查询条件及查询参数
     */
    private QueryWrapper<TContractorPreparationAnalysis> createQuery(TContractorPreparationAnalysisParam queryParam) {
        QueryWrapper<TContractorPreparationAnalysis> queryWrapper = new QueryWrapper<>();
        if (StringHelper.isNotEmpty(queryParam.getPreparationId())) {
            queryWrapper.eq(TContractorPreparationAnalysis.PREPARATION_ID, queryParam.getPreparationId());
        }
        if (StringHelper.isNotEmpty(queryParam.getWorkplace())) {
            queryWrapper.eq(TContractorPreparationAnalysis.WORKPLACE, queryParam.getWorkplace());
        }
        if (StringHelper.isNotEmpty(queryParam.getActivityName())) {
            queryWrapper.like(TContractorPreparationAnalysis.ACTIVITY_NAME, queryParam.getActivityName());
        }
        if (StringHelper.isNotEmpty(queryParam.getHazardDescription())) {
            queryWrapper.eq(TContractorPreparationAnalysis.HAZARD_DESCRIPTION, queryParam.getHazardDescription());
        }
        if (StringHelper.isNotEmpty(queryParam.getPotentialAccidentConsequences())) {
            queryWrapper.eq(TContractorPreparationAnalysis.POTENTIAL_ACCIDENT_CONSEQUENCES, queryParam.getPotentialAccidentConsequences());
        }
        if (StringHelper.isNotEmpty(queryParam.getControlMeasures())) {
            queryWrapper.eq(TContractorPreparationAnalysis.CONTROL_MEASURES, queryParam.getControlMeasures());
        }
        if (StringHelper.isNotEmpty(queryParam.getPersonId())) {
            queryWrapper.eq(TContractorPreparationAnalysis.PERSON_ID, queryParam.getPersonId());
        }
        if (StringHelper.isNotEmpty(queryParam.getStatus())) {
            queryWrapper.eq(TContractorPreparationAnalysis.STATUS, queryParam.getStatus());
        } else {
            queryWrapper.ne(TContractorPreparationAnalysis.STATUS, BizConstants.STATUS_DELETE);
        }
        if (StringHelper.isNotEmpty(queryParam.getOrderBy())) {
            if (StringHelper.isNotEmpty(queryParam.getOrderType())
                    && BizConstants.ASC.equals(queryParam.getOrderType())) {
                queryWrapper.orderByAsc(queryParam.getOrderBy());
            } else {
                queryWrapper.orderByDesc(queryParam.getOrderBy());
            }
        } else {
            queryWrapper.orderByDesc(TContractorPreparationAnalysis.UPDATE_DATE);
        }
        return queryWrapper;
    }
}
