package com.testor.module.hazard.model.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
public class HazardWorkPlanCheckDetail {

    @ApiModelProperty("大区名称")
    private String regionName;

    @ApiModelProperty("经营部名称")
    private String businessDeptName;

    @ApiModelProperty("企业名称")
    private String currentOrgName;

    // ---------------- 合规率 ----------------
    @ApiModelProperty("企业作业合规率")
    private Double enterpriseComplianceRate;

    @ApiModelProperty("相关方作业合规率")
    private Double relatedPartyComplianceRate;

    @ApiModelProperty("高度危险作业合规率")
    private Double complianceRateHigh;

    @ApiModelProperty("较大危险作业合规率")
    private Double complianceRateMajor;

    @ApiModelProperty("一般危险作业合规率")
    private Double complianceRateNormal;

    // ---------------- 抽查率 ----------------
    @ApiModelProperty("企业作业抽查率")
    private Double enterpriseCheckRate;

    @ApiModelProperty("相关方作业抽查率")
    private Double relatedPartySpotCheckRate;

    @ApiModelProperty("高度危险作业抽查率")
    private Double spotCheckRateHigh;

    @ApiModelProperty("较大危险作业抽查率")
    private Double spotCheckRateMajor;

    @ApiModelProperty("一般危险作业抽查率")
    private Double spotCheckRateNormal;

    // ---------------- 危险作业状态 ----------------
    @ApiModelProperty("问题名称")
    private String problemName;

    @ApiModelProperty("问题数量")
    private Integer problemCount;

    @ApiModelProperty("是否租户（0：否，1：是）")
    private String isRent;

}
