package com.testor.module.hazard.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.hazard.model.dto.HazardWorkPlanStatisticsDto;
import com.testor.module.hazard.model.dto.HazardWorkPlanStatisticsResult;
import com.testor.module.hazard.model.dto.THazardWorkPlanDetailStatistics;
import com.testor.module.hazard.model.dto.THazardWorkPlanStatistics;
import com.testor.module.hazard.model.template.HazardWorkPlanStatisticsTemplate;
import com.testor.module.hazard.model.vo.HazardWorkPlanStatisticsVO;
import org.apache.ibatis.annotations.Param;

import java.util.List;

public interface HazardWorkPlanStatisticsService {
    /**
     * 危险作业分布统计，根据单位
     * @param param
     * @return
     */
    public List<HazardWorkPlanStatisticsVO> statWorkPlanNumByOrg(HazardWorkPlanStatisticsDto param);

    /**
     * 危险作业数量统计，根据时间
     * @param param
     * @return
     */
    public List<HazardWorkPlanStatisticsVO> statWorkPlanNumByTime(HazardWorkPlanStatisticsDto param);

    /**
     * 相关方作业统计
     * @param param
     * @return
     */
    public List<HazardWorkPlanStatisticsVO> statStakeholderWorkNum(HazardWorkPlanStatisticsDto param);

    /**
     * 租赁库占比统计
     * @param param
     * @return
     */
    public List<HazardWorkPlanStatisticsVO> statIsRentNum(HazardWorkPlanStatisticsDto param);

    /**
     * 危险作业人员统计
     * @param param
     * @return
     */
    public List<HazardWorkPlanStatisticsVO> statOperatorNum(HazardWorkPlanStatisticsDto param);

    /**
     * 危险作业类型统计图表
     * @param hazardWorkPlanStatisticsDto
     * @return
     */
    List<THazardWorkPlanStatistics> selectHazardWorkPlanStatistics(HazardWorkPlanStatisticsDto hazardWorkPlanStatisticsDto);


    /**
     * 危险作业详情统计
     * @param query
     * @return
     */
    Page<HazardWorkPlanStatisticsResult> selectWorkStatusDetailStatistics(HazardWorkPlanStatisticsDto query); // Changed from List to Page

    /**
     * 危险作业详情统计导出
     * @param query
     * @return
     */
    List<HazardWorkPlanStatisticsTemplate> exportCompleteStatistics(HazardWorkPlanStatisticsDto query);
}
